/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.dbutils.service.TemplateVersionService;
import com.trigyn.jws.templating.service.DBTemplatingService;
import com.trigyn.jws.templating.service.MenuService;
import com.trigyn.jws.templating.vo.TemplateVO;
import com.trigyn.jws.webstarter.service.TemplateCrudService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
public class TemplateCrudController {
    private static final Logger logger = LogManager.getLogger(TemplateCrudController.class);
    @Autowired
    private DBTemplatingService dbTemplatingService = null;
    @Autowired
    private TemplateCrudService templateCrudService = null;
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    @Autowired
    private MenuService menuService = null;
    @Autowired
    private TemplateVersionService templateVersionService = null;

    @GetMapping(value={"/te"}, produces={"text/html"})
    public String templatePage(HttpServletResponse httpServletResponse) throws IOException {
        try {
            HashMap<String, String> modelMap = new HashMap<String, String>();
            String environment = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "profile");
            modelMap.put("environment", environment);
            return this.menuService.getTemplateWithSiteLayout("template-listing", modelMap);
        }
        catch (Exception exception) {
            logger.error("Error ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
            return null;
        }
    }

    @GetMapping(value={"/aet"}, produces={"text/html"})
    public String velocityTemplateEditor(HttpServletRequest request, HttpServletResponse httpServletResponse) throws IOException {
        try {
            String templateId = request.getParameter("vmMasterId");
            HashMap<String, Object> vmTemplateData = new HashMap<String, Object>();
            if (templateId != null) {
                TemplateVO templateDetails = this.dbTemplatingService.getVelocityDataById(templateId);
                Map versionDetailsMap = this.templateVersionService.getVersionDetails(templateId);
                templateDetails.setTemplate("");
                vmTemplateData.put("templateDetails", templateDetails);
                vmTemplateData.put("versionDetailsMap", versionDetailsMap);
            }
            return this.menuService.getTemplateWithSiteLayout("template-manage-details", vmTemplateData);
        }
        catch (Exception exception) {
            logger.error("Error ", (Throwable)exception);
            httpServletResponse.sendError(HttpStatus.INTERNAL_SERVER_ERROR.value(), exception.getMessage());
            return null;
        }
    }

    @RequestMapping(value={"/ctd"})
    @ResponseBody
    public String checkTemplateData(HttpServletRequest request, HttpServletResponse response) {
        String templateName = request.getParameter("templateName");
        String templateId = null;
        try {
            templateId = this.templateCrudService.checkVelocityData(templateName);
            return templateId;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @GetMapping(value={"/gtbi"})
    public String getTemplateByTemplateId(HttpServletRequest request) throws Exception {
        String templateId = request.getParameter("templateId");
        TemplateVO templateDetails = this.dbTemplatingService.getVelocityDataById(templateId);
        return templateDetails.getTemplate();
    }

    @PostMapping(value={"/std"})
    public void saveTemplateData(HttpSession session, HttpServletRequest request) throws Exception {
        this.dbTemplatingService.saveTemplateData(request);
    }

    @PostMapping(value={"/dtl"})
    public void downloadAllTemplatesToLocalDirectory(HttpSession session, HttpServletRequest request) throws Exception {
        this.templateCrudService.downloadTemplates(null);
    }

    @PostMapping(value={"/utd"})
    public void uploadAllTemplatesToDB(HttpSession session, HttpServletRequest request) throws Exception {
        this.templateCrudService.uploadTemplates(null);
    }

    @GetMapping(value={"/vtd"})
    @ResponseBody
    public String getTemplateDatabByVersion(@RequestHeader(name="template-id", required=true) String templateId, @RequestHeader(name="version-id", required=true) Double versionId) throws Exception {
        return this.templateVersionService.getTemplateData(templateId, versionId);
    }

    @PostMapping(value={"/dtbi"})
    public void downloadTemplateByIdToLocalDirectory(HttpSession session, HttpServletRequest request) throws Exception {
        String templateId = request.getParameter("templateId");
        this.templateCrudService.downloadTemplates(templateId);
    }

    @PostMapping(value={"/utdbi"})
    public void uploadTemplateByNameToDB(HttpSession session, HttpServletRequest request) throws Exception {
        String templateName = request.getParameter("templateName");
        this.templateCrudService.uploadTemplates(templateName);
    }
}

