/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trigyn.jws.dbutils.repository.PropertyMasterDAO;
import com.trigyn.jws.dbutils.service.DownloadUploadModule;
import com.trigyn.jws.dbutils.service.TemplateVersionService;
import com.trigyn.jws.dbutils.utils.FileUtilities;
import com.trigyn.jws.dynamicform.dao.DynamicFormCrudDAO;
import com.trigyn.jws.dynamicform.dao.IDynamicFormQueriesRepository;
import com.trigyn.jws.dynamicform.entities.DynamicForm;
import com.trigyn.jws.dynamicform.entities.DynamicFormSaveQuery;
import com.trigyn.jws.templating.service.MenuService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

@Service
@Transactional
public class DynamicFormCrudService {
    @Autowired
    private DynamicFormCrudDAO dynamicFormDAO = null;
    @Autowired
    private IDynamicFormQueriesRepository dynamicFormQueriesRepository = null;
    @Autowired
    @Qualifier(value="dynamic-form")
    private DownloadUploadModule downloadUploadModule = null;
    @Autowired
    private TemplateVersionService templateVersionService = null;
    @Autowired
    private MenuService menuService = null;
    @Autowired
    private PropertyMasterDAO propertyMasterDAO = null;
    @Autowired
    private FileUtilities fileUtilities = null;

    @Transactional(readOnly=true)
    public String addEditForm(String formId) throws Exception {
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        DynamicForm dynamicForm = new DynamicForm();
        if (StringUtils.isNotEmpty((CharSequence)formId)) {
            dynamicForm = this.dynamicFormDAO.findDynamicFormById(formId);
            dynamicForm.setFormBody("<#noparse>" + dynamicForm.getFormBody() + "</#noparse>");
            dynamicForm.setFormSelectQuery("<#noparse>" + dynamicForm.getFormSelectQuery() + "</#noparse>");
            Map versionDetailsMap = this.templateVersionService.getVersionDetails(formId);
            templateMap.put("versionDetailsMap", versionDetailsMap);
        } else {
            List tables = this.dynamicFormDAO.getAllTablesListInSchema();
            templateMap.put("tables", tables);
        }
        templateMap.put("dynamicForm", dynamicForm);
        return this.menuService.getTemplateWithSiteLayout("dynamic-form-manage-details", templateMap);
    }

    @Transactional(readOnly=false)
    public void saveDynamicFormDetails(MultiValueMap<String, String> formData) throws Exception {
        DynamicForm dynamicForm = new DynamicForm();
        ArrayList<DynamicFormSaveQuery> dynamicFormSaveQueries = new ArrayList<DynamicFormSaveQuery>();
        String formId = ((String)formData.getFirst((Object)"formId")).toString();
        if (StringUtils.isNotEmpty((CharSequence)formId)) {
            dynamicForm = this.dynamicFormDAO.findDynamicFormById(formId);
        } else {
            dynamicForm.setCreatedBy("admin");
            dynamicForm.setCreatedDate(new Date());
        }
        dynamicForm.setFormDescription(((String)formData.getFirst((Object)"formDescription")).toString());
        dynamicForm.setFormSelectQuery(((String)formData.getFirst((Object)"formSelectQuery")).toString());
        dynamicForm.setFormBody(((String)formData.getFirst((Object)"formBody")).toString());
        dynamicForm.setFormName(((String)formData.getFirst((Object)"formName")).toString());
        dynamicForm.setDynamicFormSaveQueries(dynamicFormSaveQueries);
        this.dynamicFormDAO.saveDynamicFormData(dynamicForm);
        List<DynamicFormSaveQuery> formSaveQueries = this.saveDynamicFormQueries(formData, dynamicForm.getFormId(), dynamicFormSaveQueries, formId);
        dynamicForm.setDynamicFormSaveQueries(formSaveQueries);
        String environment = this.propertyMasterDAO.findPropertyMasterValue("system", "system", "profile");
        if (environment.equalsIgnoreCase("dev")) {
            this.downloadUploadModule.downloadCodeToLocal((Object)dynamicForm);
        }
        this.templateVersionService.saveTemplateVersion((Object)dynamicForm, null, (Object)dynamicForm.getFormId(), "dynamic_form");
    }

    private List<DynamicFormSaveQuery> saveDynamicFormQueries(MultiValueMap<String, String> formData, String dynamicFormId, List<DynamicFormSaveQuery> dynamicFormSaveQueries, String formId) throws JsonProcessingException, JsonMappingException, Exception {
        String formSaveQueryId = (String)formData.getFirst((Object)"formSaveQueryId");
        String queriesList = (String)formData.getFirst((Object)"formSaveQuery");
        List formSaveQueryIdList = (List)new ObjectMapper().readValue(formSaveQueryId, List.class);
        List queries = (List)new ObjectMapper().readValue(queriesList, List.class);
        this.dynamicFormDAO.deleteFormQueriesByIds(formId, formSaveQueryIdList);
        for (int queryCounter = 0; queryCounter < queries.size(); ++queryCounter) {
            DynamicFormSaveQuery dynamicFormSaveQuery = new DynamicFormSaveQuery();
            if (!CollectionUtils.isEmpty((Collection)formSaveQueryIdList) && formSaveQueryIdList.size() > queryCounter) {
                dynamicFormSaveQuery.setDynamicFormQueryId((String)formSaveQueryIdList.get(queryCounter));
            }
            dynamicFormSaveQuery.setDynamicFormId(dynamicFormId);
            dynamicFormSaveQuery.setDynamicFormSaveQuery((String)queries.get(queryCounter));
            dynamicFormSaveQuery.setSequence(Integer.valueOf(queryCounter + 1));
            dynamicFormSaveQueries.add(dynamicFormSaveQuery);
        }
        return this.dynamicFormQueriesRepository.saveAll(dynamicFormSaveQueries);
    }

    public List<Map<String, Object>> getAllFormQueriesById(String formId) throws Exception {
        ArrayList<Map<String, Object>> dynamicFormList = new ArrayList<Map<String, Object>>();
        List dynamicFormSaveQueryList = this.dynamicFormDAO.findDynamicFormQueriesById(formId);
        DynamicForm dynamicForm = this.dynamicFormDAO.findDynamicFormById(formId);
        for (DynamicFormSaveQuery dynamicFormSaveQuery : dynamicFormSaveQueryList) {
            Map versionDetailsMap = this.templateVersionService.getVersionDetails(dynamicFormSaveQuery.getDynamicFormQueryId());
            HashMap<String, Object> formSaveQueryMap = new HashMap<String, Object>();
            formSaveQueryMap.put("formQueryId", dynamicFormSaveQuery.getDynamicFormQueryId());
            formSaveQueryMap.put("formSaveQuery", dynamicFormSaveQuery.getDynamicFormSaveQuery());
            formSaveQueryMap.put("sequence", dynamicFormSaveQuery.getSequence());
            formSaveQueryMap.put("versionDetailsMap", versionDetailsMap);
            formSaveQueryMap.put("formBody", dynamicForm.getFormBody());
            dynamicFormList.add(formSaveQueryMap);
        }
        return dynamicFormList;
    }

    @Transactional(readOnly=true)
    public String checkFormName(String formName) {
        return this.dynamicFormDAO.checkFormName(formName);
    }

    public void downloadDynamicFormsTemplate(String formId) throws Exception {
        if (!StringUtils.isBlank((CharSequence)formId)) {
            DynamicForm dynamicForm = this.dynamicFormDAO.findDynamicFormById(formId);
            this.downloadUploadModule.downloadCodeToLocal((Object)dynamicForm);
        } else {
            this.downloadUploadModule.downloadCodeToLocal(null);
        }
    }

    public void uploadFormsToDB(String formName) throws Exception {
        this.downloadUploadModule.uploadCodeToDB(formName);
    }
}

