/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.menu.service.MenuService;
import com.trigyn.jws.menu.service.ModuleService;
import com.trigyn.jws.menu.vo.ModuleDetailsVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@RestController
@RequestMapping(value={"/cf"})
public class MenuCrudController {
    private static final Logger logger = LogManager.getLogger(MenuCrudController.class);
    @Autowired
    private ModuleService moduleService = null;
    @Autowired
    private MenuService menuService = null;
    @Autowired
    private RequestMappingHandlerMapping handlerMapping = null;

    @GetMapping(value={"/mul"}, produces={"text/html"})
    public String moduleListingPage() throws Exception {
        return this.menuService.getTemplateWithSiteLayout("menu-module-listing", new HashMap());
    }

    @PostMapping(value={"/aem"}, produces={"text/html"})
    public String addEditModule(@RequestParam(value="module-id") String moduleId, HttpServletRequest a_httHttpServletRequest) throws Exception {
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        ModuleDetailsVO moduleDetailsVO = this.moduleService.getModuleDetails(moduleId);
        List moduleListingVOList = this.moduleService.getAllModules(moduleId);
        List moduleTargetLookupVOList = this.moduleService.getAllModuleLookUp();
        List userRoleVOs = this.moduleService.getAllUserRoles();
        String uri = a_httHttpServletRequest.getRequestURI();
        String url = a_httHttpServletRequest.getRequestURL().toString();
        StringBuilder urlPrefix = new StringBuilder();
        url = url.replace(uri, "");
        urlPrefix.append(url).append("/view/");
        templateMap.put("urlPrefix", urlPrefix);
        templateMap.put("userRoleVOs", userRoleVOs);
        templateMap.put("moduleDetailsVO", moduleDetailsVO);
        templateMap.put("moduleListingVOList", moduleListingVOList);
        templateMap.put("moduleTargetLookupVOList", moduleTargetLookupVOList);
        return this.menuService.getTemplateWithSiteLayout("addEditModule", templateMap);
    }

    @GetMapping(value={"/ltlm"}, produces={"application/json"})
    public List<Map<String, Object>> getTargetTypes(@RequestHeader(value="target-lookup-id", required=true) Integer targetLookupId) throws Exception {
        return this.moduleService.getTargetTypes(targetLookupId, null);
    }

    @GetMapping(value={"/cms"})
    @ResponseBody
    public String checkSequenceNumber(@RequestHeader(name="parent-module-id", required=false) String parentModuleId, @RequestHeader(name="sequence", required=true) Integer sequence) throws Exception {
        try {
            return this.moduleService.getModuleIdBySequence(parentModuleId, sequence);
        }
        catch (Exception e) {
            return "Error occurred";
        }
    }

    @GetMapping(value={"/cmurl"})
    @ResponseBody
    public String checkModuleURL(@RequestHeader(name="module-url", required=false) String moduleURL) throws Exception {
        return this.moduleService.getModuleIdByURL(moduleURL);
    }

    @GetMapping(value={"/ced"}, produces={"application/json"})
    public Map<String, Object> getExistingData(@RequestHeader(name="module-name", required=false) String moduleName, @RequestHeader(name="parent-module-id", required=false) String parentModuleId, @RequestHeader(name="sequence", required=true) Integer sequence, @RequestHeader(name="module-url", required=false) String moduleURL) throws Exception {
        return this.moduleService.getExistingModuleData(moduleName, parentModuleId, sequence, moduleURL);
    }

    @PostMapping(value={"/sm"})
    @ResponseBody
    public String saveModule(@RequestBody ModuleDetailsVO moduleDetailsVO) throws Exception {
        List systemUrls = this.handlerMapping.getHandlerMethods().keySet().stream().map(requestMappingInfo -> requestMappingInfo.getPatternsCondition()).collect(Collectors.toList());
        for (Object object : systemUrls) {
            System.out.println(object);
        }
        return this.moduleService.saveModuleDetails(moduleDetailsVO);
    }
}

