/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.google.gson.Gson;
import com.trigyn.jws.dbutils.spi.IUserDetailsService;
import com.trigyn.jws.dbutils.vo.UserDetailsVO;
import com.trigyn.jws.menu.service.MenuService;
import com.trigyn.jws.notification.entities.GenericUserNotification;
import com.trigyn.jws.notification.service.NotificationService;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
public class NotificationCrudController {
    private static final Logger logger = LogManager.getLogger(NotificationCrudController.class);
    @Autowired
    private NotificationService notificationService = null;
    @Autowired
    private IUserDetailsService userDetailsService = null;
    @Autowired
    private MenuService menuService = null;

    @GetMapping(value={"/nl"}, produces={"text/html"})
    public String getGenericUserNotificationHome(HttpSession session, HttpServletRequest request) throws Exception {
        return this.menuService.getTemplateWithSiteLayout("notification-listing", new HashMap());
    }

    @GetMapping(value={"/aen"}, produces={"text/html"})
    public String createNewUserNotification(HttpSession session, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String dateFormat = "dd-MMM-yyyy";
        String dateFormat_JS = "dd-M-yy";
        HashMap<String, Object> templateDetails = new HashMap<String, Object>();
        templateDetails.put("dateFormatter", new SimpleDateFormat(dateFormat));
        templateDetails.put("dataFormat_JS", dateFormat_JS);
        String notificationId = request.getParameter("notificationId");
        if (notificationId != null) {
            GenericUserNotification genericUserNotificationDetails = this.notificationService.getNotification(notificationId);
            if (genericUserNotificationDetails == null) {
                response.sendError(404, "Invalid Notification Id");
                return null;
            }
            String obj = new Gson().toJson((Object)genericUserNotificationDetails);
            templateDetails.put("genericUserNotificationDetails", obj);
            templateDetails.put("isEdited", true);
        } else {
            templateDetails.put("isEdited", false);
        }
        return this.menuService.getTemplateWithSiteLayout("createNewUserNotification", templateDetails);
    }

    @PostMapping(value={"/sn"}, produces={"application/json"})
    public Boolean saveEditedNotification(HttpSession session, HttpServletRequest request) throws Exception {
        UserDetailsVO detailsVO = this.userDetailsService.getUserDetails();
        String updatedBy = detailsVO.getUserId();
        this.notificationService.saveEditedNotificationData(GenericUserNotification.createGenericUserNotification((String)updatedBy, (String)"dd-MMM-yyyy", (Map)request.getParameterMap()));
        return true;
    }
}

