/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.controller;

import com.trigyn.jws.menu.service.MenuService;
import com.trigyn.jws.typeahead.model.AutocompleteVO;
import com.trigyn.jws.typeahead.service.TypeAheadService;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cf"})
public class TypeAheadCrudController {
    private static final Logger logger = LogManager.getLogger(TypeAheadCrudController.class);
    @Autowired
    private TypeAheadService typeAheadService = null;
    @Autowired
    private MenuService menuService = null;

    @GetMapping(value={"/adl"}, produces={"text/html"})
    public String autocompleteListingsPage() throws Exception {
        return this.menuService.getTemplateWithSiteLayout("autocompleteListing", new HashMap());
    }

    @GetMapping(value={"/da"}, produces={"text/html"})
    public String demoAutocomplete() throws Exception {
        return this.menuService.getTemplateWithSiteLayout("demoAutocomplete", new HashMap());
    }

    @GetMapping(value={"/aea"}, produces={"text/html"})
    public String addEditAutocompleteDetails(HttpServletRequest request) throws Exception {
        String autocompleteId = request.getParameter("acId");
        HashMap<String, AutocompleteVO> templateData = new HashMap<String, AutocompleteVO>();
        if (autocompleteId != null) {
            AutocompleteVO autocompleteVO = this.typeAheadService.getAutocompleteDetailsId(autocompleteId);
            templateData.put("autocompleteVO", autocompleteVO);
        }
        return this.menuService.getTemplateWithSiteLayout("addEditAutocompleteDetails", templateData);
    }
}

