/*
 * Decompiled with CFR 0.152.
 */
package com.trigyn.jws.webstarter.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.trigyn.jws.dynamicform.dao.DynamicFormCrudDAO;
import com.trigyn.jws.dynamicform.dao.IDynamicFormQueriesRepository;
import com.trigyn.jws.dynamicform.entities.DynamicForm;
import com.trigyn.jws.dynamicform.entities.DynamicFormSaveQuery;
import com.trigyn.jws.dynamicform.vo.DynamicFormSaveQueryVO;
import com.trigyn.jws.templating.service.DBTemplatingService;
import com.trigyn.jws.templating.utils.TemplatingUtils;
import com.trigyn.jws.templating.vo.TemplateVO;
import com.trigyn.jws.webstarter.utils.DownloadUploadModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

@Service
@Transactional
public class DynamicFormCrudService {
    @Autowired
    private DynamicFormCrudDAO dynamicFormDAO = null;
    @Autowired
    private TemplatingUtils templateEngine = null;
    @Autowired
    private DBTemplatingService templatingService = null;
    @Autowired
    private IDynamicFormQueriesRepository dynamicFormQueriesRepository = null;
    @Autowired
    @Qualifier(value="dynamic-form")
    private DownloadUploadModule downloadUploadModule = null;

    public String addEditForm(String formId) throws Exception {
        HashMap templateMap = new HashMap();
        TemplateVO templateVO = this.templatingService.getTemplateByName("dynamic-form-manage-details");
        DynamicForm dynamicForm = new DynamicForm();
        if (StringUtils.isNotEmpty((CharSequence)formId)) {
            dynamicForm = this.dynamicFormDAO.findDynamicFormById(formId);
        } else {
            List tables = this.dynamicFormDAO.getAllTablesListInSchema();
            templateMap.put("tables", tables);
        }
        templateMap.put("dynamicForm", dynamicForm);
        return this.templateEngine.processTemplateContents(templateVO.getTemplate(), templateVO.getTemplateName(), templateMap);
    }

    @Transactional(readOnly=false)
    public void saveDynamicFormDetails(MultiValueMap<String, String> formData) throws Exception {
        DynamicForm dynamicForm = new DynamicForm();
        ArrayList<DynamicFormSaveQuery> dynamicFormSaveQueries = new ArrayList<DynamicFormSaveQuery>();
        String formId = ((String)formData.getFirst((Object)"formId")).toString();
        if (StringUtils.isNotEmpty((CharSequence)formId)) {
            dynamicForm = this.dynamicFormDAO.findDynamicFormById(formId);
        } else {
            dynamicForm.setCreatedBy("admin");
            dynamicForm.setCreatedDate(new Date());
        }
        dynamicForm.setFormDescription(((String)formData.getFirst((Object)"formDescription")).toString());
        dynamicForm.setFormSelectQuery(((String)formData.getFirst((Object)"formSelectQuery")).toString());
        dynamicForm.setFormBody(((String)formData.getFirst((Object)"formBody")).toString());
        dynamicForm.setFormName(((String)formData.getFirst((Object)"formName")).toString());
        dynamicForm.setDynamicFormSaveQueries(dynamicFormSaveQueries);
        this.dynamicFormDAO.saveDynamicFormData(dynamicForm);
        String queriesList = (String)formData.getFirst((Object)"formSaveQuery");
        List queries = (List)new ObjectMapper().readValue(queriesList, List.class);
        if (!CollectionUtils.isEmpty((Collection)queries)) {
            this.dynamicFormDAO.deleteFormQueries(formId);
        }
        int counter = 1;
        for (String query : queries) {
            DynamicFormSaveQuery dynamicFormSaveQuery = new DynamicFormSaveQuery();
            dynamicFormSaveQuery.setDynamicFormId(dynamicForm.getFormId());
            dynamicFormSaveQuery.setDynamicFormSaveQuery(query);
            dynamicFormSaveQuery.setSequence(Integer.valueOf(counter));
            ++counter;
            dynamicFormSaveQueries.add(dynamicFormSaveQuery);
        }
        this.dynamicFormQueriesRepository.saveAll(dynamicFormSaveQueries);
        ArrayList<DynamicForm> form = new ArrayList<DynamicForm>();
        form.add(dynamicForm);
    }

    public List<DynamicFormSaveQueryVO> getAllFormQueriesById(String formId) {
        return this.dynamicFormDAO.findDynamicFormQueriesById(formId).stream().map(queries -> new DynamicFormSaveQueryVO(queries.getDynamicFormSaveQuery(), queries.getSequence())).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public String checkFormName(String formName) {
        return this.dynamicFormDAO.checkFormName(formName);
    }

    public void downloadDynamicFormTemplates() throws Exception {
        this.downloadUploadModule.downloadCodeToLocal();
    }

    public void uploadAllFormsToDB() throws Exception {
        this.downloadUploadModule.uploadCodeToDB();
    }
}

