/*
 * Decompiled with CFR 0.152.
 */
package com.trolley.trolley;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.trolley.trolley.Compliance;
import com.trolley.trolley.Configuration;
import com.trolley.trolley.Recipient;
import com.trolley.trolley.RecipientAccount;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Payment {
    private String id;
    private Recipient recipient;
    private String status;
    private Boolean isSupplyPayment;
    private String returnedAmount;
    private String amount;
    private String currency;
    private String category;
    private RecipientAccount account;
    private List<String> tags;
    private String sourceAmount;
    private String sourceCurrency;
    private String targetAmount;
    private String targetCurrency;
    private String exchangeRate;
    private String fees;
    private String recipientFees;
    private String fxRate;
    private String memo;
    private String externalId;
    private Object processedAt;
    private String createdAt;
    private String updatedAt;
    private String merchantFees;
    private Compliance compliance;
    private String payoutMethod;
    private String methodDisplay;
    Object batch;
    String withholdingAmount;
    String withholdingCurrency;
    String equivalentWithholdingAmount;
    String equivalentWithholdingCurrency;

    public void setEquivalentWithholdingCurrency(String equivalentWithholdingCurrency) {
        this.equivalentWithholdingCurrency = equivalentWithholdingCurrency;
    }

    public String getEquivalentWithholdingCurrency() {
        return this.equivalentWithholdingCurrency;
    }

    public void setEquivalentWithholdingAmount(String equivalentWithholdingAmount) {
        this.equivalentWithholdingAmount = equivalentWithholdingAmount;
    }

    public String getEquivalentWithholdingAmount() {
        return this.equivalentWithholdingAmount;
    }

    public void setWithholdingCurrency(String withholdingCurrency) {
        this.withholdingCurrency = withholdingCurrency;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public RecipientAccount getAccount() {
        return this.account;
    }

    public void setAccount(RecipientAccount account) {
        this.account = account;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getWithholdingCurrency() {
        return this.withholdingCurrency;
    }

    public void setWithholdingAmount(String withholdingAmount) {
        this.withholdingAmount = withholdingAmount;
    }

    public String getWithholdingAmount() {
        return this.withholdingAmount;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Recipient getRecipient() {
        return this.recipient;
    }

    public void setRecipient(Recipient recipient) {
        this.recipient = recipient;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Boolean getIsSupplyPayment() {
        return this.isSupplyPayment;
    }

    public void setIsSupplyPayment(Boolean isSupplyPayment) {
        this.isSupplyPayment = isSupplyPayment;
    }

    public String getReturnedAmount() {
        return this.returnedAmount;
    }

    public void setReturnedAmount(String returnedAmount) {
        this.returnedAmount = returnedAmount;
    }

    public String getSourceAmount() {
        return this.sourceAmount;
    }

    public void setSourceAmount(String sourceAmount) {
        this.sourceAmount = sourceAmount;
    }

    public String getSourceCurrency() {
        return this.sourceCurrency;
    }

    public void setSourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    public String getTargetAmount() {
        return this.targetAmount;
    }

    public void setTargetAmount(String targetAmount) {
        this.targetAmount = targetAmount;
    }

    public String getTargetCurrency() {
        return this.targetCurrency;
    }

    public void setTargetCurrency(String targetCurrency) {
        this.targetCurrency = targetCurrency;
    }

    public String getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(String exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public String getFees() {
        return this.fees;
    }

    public void setFees(String fees) {
        this.fees = fees;
    }

    public String getRecipientFees() {
        return this.recipientFees;
    }

    public void setRecipientFees(String recipientFees) {
        this.recipientFees = recipientFees;
    }

    public String getFxRate() {
        return this.fxRate;
    }

    public void setFxRate(String fxRate) {
        this.fxRate = fxRate;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Object getProcessedAt() {
        return this.processedAt;
    }

    public void setProcessedAt(Object processedAt) {
        this.processedAt = processedAt;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getMerchantFees() {
        return this.merchantFees;
    }

    public void setMerchantFees(String merchantFees) {
        this.merchantFees = merchantFees;
    }

    public Compliance getCompliance() {
        return this.compliance;
    }

    public void setCompliance(Compliance compliance) {
        this.compliance = compliance;
    }

    public String getPayoutMethod() {
        return this.payoutMethod;
    }

    public void setPayoutMethod(String payoutMethod) {
        this.payoutMethod = payoutMethod;
    }

    public String getMethodDisplay() {
        return this.methodDisplay;
    }

    public void setMethodDisplay(String methodDisplay) {
        this.methodDisplay = methodDisplay;
    }

    public static Payment find(String payment_id, String batch_id) throws Exception {
        return Configuration.gateway().payment.find(payment_id, batch_id);
    }

    public static Payment create(String body, String batch_id) throws Exception {
        return Configuration.gateway().payment.create(body, batch_id);
    }

    public static boolean update(String payment_id, String body, String batch_id) throws Exception {
        return Configuration.gateway().payment.update(payment_id, body, batch_id);
    }

    public static boolean delete(String payment_id, String batch_id) throws Exception {
        return Configuration.gateway().payment.delete(payment_id, batch_id);
    }

    public static List<Payment> query(String batch_id, int page, int pageSize, String message) throws Exception {
        return Configuration.gateway().payment.query(batch_id, page, pageSize, message);
    }

    public static List<Payment> query(String batch_id, String message) throws Exception {
        return Payment.query(batch_id, 1, 10, message);
    }

    public static List<Payment> query(String batch_id) throws Exception {
        return Payment.query(batch_id, 1, 10, "");
    }

    public static List<Payment> query(String batch_id, int page, int pageSize) throws Exception {
        return Payment.query(batch_id, page, pageSize, "");
    }
}

