/*
 * Decompiled with CFR 0.152.
 */
package com.trolley.trolley;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trolley.Exceptions.InvalidFieldException;
import com.trolley.trolley.Client;
import com.trolley.trolley.Configuration;
import com.trolley.trolley.Payment;
import com.trolley.trolley.Recipient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RecipientGateway {
    Client client;

    public RecipientGateway(Configuration config) {
        this.client = new Client(config);
    }

    public Recipient find(String recipient_id) throws Exception {
        if (recipient_id == null || recipient_id.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        String endPoint = "/v1/recipients/" + recipient_id;
        String response = this.client.get(endPoint);
        return this.recipientFactory(response);
    }

    public String findLogs(String recipient_id) throws Exception {
        String endPoint = "/v1/recipients/" + recipient_id + "/logs";
        String response = this.client.get(endPoint);
        return response;
    }

    public List<Payment> findPayments(String recipient_id) throws Exception {
        String endPoint = "/v1/recipients/" + recipient_id + "/payments";
        String response = this.client.get(endPoint);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(response);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object payment = mapper.readValue(node.get("payments").traverse(), Object.class);
        List paymens = (List)payment;
        ArrayList<Payment> payments = new ArrayList<Payment>();
        for (int i = 0; i < paymens.size(); ++i) {
            Payment pojo = (Payment)mapper.convertValue(paymens.get(i), Payment.class);
            payments.add(pojo);
        }
        return payments;
    }

    public Recipient create(String body) throws Exception {
        if (body == null || body.isEmpty()) {
            throw new InvalidFieldException("Body cannot be null or empty");
        }
        String endPoint = "/v1/recipients/";
        String response = this.client.post(endPoint, body);
        return this.recipientFactory(response);
    }

    public Recipient create(Recipient recipient) throws Exception {
        if (recipient == null) {
            throw new InvalidFieldException("Body cannot be null or empty");
        }
        String jsonRecipient = new ObjectMapper().writeValueAsString((Object)recipient);
        String endPoint = "/v1/recipients/";
        String response = this.client.post(endPoint, jsonRecipient);
        return this.recipientFactory(response);
    }

    public boolean update(String recipient_id, String body) throws Exception {
        if (recipient_id == null || recipient_id.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        if (body == null || body.isEmpty()) {
            throw new InvalidFieldException("Body cannot be null or empty");
        }
        String endPoint = "/v1/recipients/" + recipient_id;
        this.client.patch(endPoint, body);
        return true;
    }

    public boolean update(String recipient_id, Recipient recipient) throws Exception {
        if (recipient_id == null || recipient_id.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        if (recipient == null) {
            throw new InvalidFieldException("Body cannot be null or empty");
        }
        String jsonRecipient = new ObjectMapper().writeValueAsString((Object)recipient);
        String endPoint = "/v1/recipients/" + recipient_id;
        this.client.patch(endPoint, jsonRecipient);
        return true;
    }

    public boolean delete(String recipient_id) throws Exception {
        if (recipient_id == null || recipient_id.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        String endPoint = "/v1/recipients/" + recipient_id;
        this.client.delete(endPoint);
        return true;
    }

    public List<Recipient> search(int page, int pageSize, String term) throws Exception {
        if (page < 0) {
            throw new InvalidFieldException("Page cannot be less than 0");
        }
        if (pageSize < 0) {
            throw new InvalidFieldException("Page size cannot be less than 0");
        }
        if (term == null) {
            throw new InvalidFieldException("Message cannot be null");
        }
        String endPoint = "/v1/recipients/?&search=" + term + "&page=" + page + "&pageSize=" + pageSize;
        String response = this.client.get(endPoint);
        return this.recipientListFactory(response);
    }

    private Recipient recipientFactory(String data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(data);
        Recipient recipient = (Recipient)mapper.readValue(node.get("recipient").traverse(), Recipient.class);
        return recipient;
    }

    private List<Recipient> recipientListFactory(String data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(data);
        Object recipient = mapper.readValue(node.get("recipients").traverse(), Object.class);
        List recips = (List)recipient;
        ArrayList<Recipient> recipients = new ArrayList<Recipient>();
        for (int i = 0; i < recips.size(); ++i) {
            Recipient pojo = (Recipient)mapper.convertValue(recips.get(i), Recipient.class);
            recipients.add(pojo);
        }
        return recipients;
    }
}

