/*
 * Decompiled with CFR 0.152.
 */
package com.trolley.trolley;

import com.trolley.trolley.Client;
import com.trolley.trolley.Gateway;

public class Configuration {
    String apiBase = "https://api.trolley.com";
    String privateKey = "";
    String publicKey = "";

    public Configuration() {
    }

    public Configuration(String publicKey, String privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public Configuration(String publicKey, String privateKey, String apiBase) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.apiBase = this.setEnviroment(apiBase);
    }

    public String getApiBase() {
        return this.apiBase;
    }

    public void setApiBase(String apiBase) {
        this.apiBase = apiBase;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privatKey) {
        this.privateKey = privatKey;
    }

    public static Gateway gateway() {
        return new Gateway(Configuration.instantiate());
    }

    public static Client client(Configuration config) {
        return new Client(config);
    }

    public static Configuration instantiate() {
        return new Configuration();
    }

    public String setEnviroment(String enviroment) {
        switch (enviroment) {
            case "production": 
            case "PRODUCTION": {
                return "https://api.trolley.com";
            }
            case "development": 
            case "DEVELOPMENT": {
                return "http://api.railz.io";
            }
            case "integration": 
            case "INTEGRATION": {
                return "http://api.local.dev:3000";
            }
            case "sandbox": 
            case "SANDBOX": {
                return "https://api.trolley.com";
            }
        }
        return "https://api.trolley.com";
    }
}

