/*
 * Decompiled with CFR 0.152.
 */
package com.trolley.trolley;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trolley.trolley.InvoiceLine;
import com.trolley.trolley.types.Amount;
import com.trolley.trolley.types.Invoices;
import com.trolley.trolley.types.Meta;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Invoice {
    private String id;
    private String invoiceId;
    private String invoiceNumber;
    private String description;
    private String status;
    private String externalId;
    private String invoiceDate;
    private String dueDate;
    private String createdAt;
    private String updatedAt;
    private Amount totalAmount;
    private Amount paidAmount;
    private Amount dueAmount;
    private List<String> tags;
    private List<InvoiceLine> lines;
    private String recipientId;

    public Invoice() {
    }

    public Invoice(String recipientId, String invoiceNumber, String description, String externalId, String invoiceDate, String dueDate, List<String> tags, List<InvoiceLine> lines) {
        this.invoiceNumber = invoiceNumber;
        this.description = description;
        this.externalId = externalId;
        this.invoiceDate = invoiceDate;
        this.dueDate = dueDate;
        this.tags = tags;
        this.lines = lines;
        this.recipientId = recipientId;
    }

    private Invoice(String id, String invoiceId, String invoiceNumber, String description, String status, String externalId, String invoiceDate, String dueDate, String createdAt, String updatedAt, Amount totalAmount, Amount paidAmount, Amount dueAmount, List<String> tags, List<InvoiceLine> lines, String recipientId) {
        this.id = id;
        this.invoiceId = invoiceId;
        this.invoiceNumber = invoiceNumber;
        this.description = description;
        this.status = status;
        this.externalId = externalId;
        this.invoiceDate = invoiceDate;
        this.dueDate = dueDate;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.totalAmount = totalAmount;
        this.paidAmount = paidAmount;
        this.dueAmount = dueAmount;
        this.tags = tags;
        this.lines = lines;
        this.recipientId = recipientId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(String invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public String getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Amount getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Amount totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Amount getPaidAmount() {
        return this.paidAmount;
    }

    public void setPaidAmount(Amount paidAmount) {
        this.paidAmount = paidAmount;
    }

    public Amount getDueAmount() {
        return this.dueAmount;
    }

    public void setDueAmount(Amount dueAmount) {
        this.dueAmount = dueAmount;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public List<InvoiceLine> getLines() {
        return this.lines;
    }

    public void setLines(List<InvoiceLine> lines) {
        this.lines = lines;
    }

    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public static Invoice invoiceFactory(String invoiceStr) throws JsonMappingException, JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(invoiceStr);
        String invoiceId = node.get("invoice").get("id").asText();
        try {
            Invoice invoice = (Invoice)mapper.readValue(node.get("invoice").traverse(), Invoice.class);
            return invoice;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Invoice(invoiceId, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }

    public static Invoices invoiceListFactory(String invoicesStr) throws StreamReadException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(invoicesStr);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object invoice = mapper.readValue(node.get("invoices").traverse(), Object.class);
        List parsedInvoices = (List)invoice;
        ArrayList<Invoice> invoiceObjs = new ArrayList<Invoice>();
        Meta meta = (Meta)mapper.readValue(node.get("meta").traverse(), Meta.class);
        for (Object singleInvoice : parsedInvoices) {
            Invoice pojo = (Invoice)mapper.convertValue(singleInvoice, Invoice.class);
            invoiceObjs.add(pojo);
        }
        return new Invoices(invoiceObjs, meta);
    }

    public String toString() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        String jsonString = null;
        try {
            jsonString = objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return jsonString;
    }

    public static enum SearchBy {
        INVOICE_ID("invoiceId"),
        RECIPIENT_ID("recipientId"),
        INVOICE_NUMBER("invoiceNumber"),
        INVOICE_DATE("invoiceDate"),
        EXTERNAL_ID("externalId"),
        TAGS("tags");

        private String key;

        private SearchBy(String key) {
            this.key = key;
        }

        @JsonCreator
        public static SearchBy fromString(String key) {
            return key == null ? null : SearchBy.valueOf(key.toUpperCase(Locale.US));
        }

        @JsonValue
        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.key.toLowerCase(Locale.US);
        }
    }
}

