/*
 * Decompiled with CFR 0.152.
 */
package com.trolley.trolley;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trolley.trolley.types.InvoicePaymentPart;
import com.trolley.trolley.types.InvoicePayments;
import com.trolley.trolley.types.Meta;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InvoicePayment {
    private String batchId;
    private String paymentId;
    private List<InvoicePaymentPart> invoicePayments;

    public InvoicePayment() {
    }

    public InvoicePayment(List<InvoicePaymentPart> invoicePayments) {
        this.invoicePayments = invoicePayments;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public List<InvoicePaymentPart> getInvoicePayments() {
        return this.invoicePayments;
    }

    public void setInvoicePayments(List<InvoicePaymentPart> invoicePayments) {
        this.invoicePayments = invoicePayments;
    }

    public static InvoicePayment invoicePaymentFactory(String invoicePaymentResponse) throws JsonMappingException, JsonProcessingException {
        InvoicePayment invoicePayment;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(invoicePaymentResponse);
        String paymentId = node.get("invoicePayment").get("paymentId").asText();
        try {
            invoicePayment = (InvoicePayment)mapper.readValue(node.get("invoicePayment").traverse(), InvoicePayment.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            invoicePayment = new InvoicePayment(null);
            invoicePayment.setPaymentId(paymentId);
        }
        return invoicePayment;
    }

    public static InvoicePayments invoicePaymentsFactory(String invoicePaymentResponse) throws StreamReadException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(invoicePaymentResponse);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object invoicePayments = mapper.readValue(node.get("invoicePayments").traverse(), Object.class);
        List parsedInvoicePayments = (List)invoicePayments;
        ArrayList<InvoicePaymentPart> paymentPartsObjs = new ArrayList<InvoicePaymentPart>();
        Meta meta = (Meta)mapper.readValue(node.get("meta").traverse(), Meta.class);
        for (Object invoicePayment : parsedInvoicePayments) {
            InvoicePaymentPart pojo = (InvoicePaymentPart)mapper.convertValue(invoicePayment, InvoicePaymentPart.class);
            paymentPartsObjs.add(pojo);
        }
        return new InvoicePayments(paymentPartsObjs, meta);
    }

    public String toString() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        String jsonString = null;
        try {
            jsonString = objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return jsonString;
    }
}

