/*
 * Decompiled with CFR 0.152.
 */
package com.trolley.trolley;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trolley.trolley.Client;
import com.trolley.trolley.Configuration;
import com.trolley.trolley.InvoicePayment;
import com.trolley.trolley.types.InvoicePaymentPart;
import com.trolley.trolley.types.InvoicePayments;
import java.util.ArrayList;
import java.util.List;

public class InvoicePaymentGateway {
    Client client;

    public InvoicePaymentGateway(Configuration config) {
        this.client = new Client(config);
    }

    public InvoicePayment create(String batchId, final InvoicePaymentPart payment) throws Exception {
        String endPoint = "/v1/invoices/payment/create/";
        String body = "";
        body = null != batchId && !batchId.isEmpty() ? "{ \"batchId\": \"" + batchId + "\"," : "{";
        ArrayList<InvoicePaymentPart> invoicePaymentParts = new ArrayList<InvoicePaymentPart>(){
            {
                this.add(payment);
            }
        };
        body = body + "\"ids\":" + new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString((Object)invoicePaymentParts) + "}";
        String response = this.client.post("/v1/invoices/payment/create/", body);
        return InvoicePayment.invoicePaymentFactory(response);
    }

    public InvoicePayment create(String batchId, List<InvoicePaymentPart> invoicePaymentParts) throws Exception {
        String endPoint = "/v1/invoices/payment/create/";
        String body = "";
        body = null != batchId && !batchId.isEmpty() ? "{ \"batchId\": \"" + batchId + "\"," : "{";
        body = body + "\"ids\":" + new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString(invoicePaymentParts) + "}";
        String response = this.client.post("/v1/invoices/payment/create/", body);
        return InvoicePayment.invoicePaymentFactory(response);
    }

    public boolean update(InvoicePaymentPart invoicePaymentPart) throws Exception {
        String endPoint = "/v1/invoices/payment/update/";
        String body = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString((Object)invoicePaymentPart);
        String response = this.client.post("/v1/invoices/payment/update/", body);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(response);
        return node.get("ok").asBoolean(false);
    }

    public InvoicePayments search(List<String> paymentIds, List<String> invoiceIds) throws Exception {
        String endPoint = "/v1/invoices/payment/search/";
        String body = "{";
        if (null != paymentIds && !paymentIds.isEmpty()) {
            body = body + "\"paymentIds\":" + new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString(paymentIds);
        }
        if (null != invoiceIds && !invoiceIds.isEmpty()) {
            if (null != paymentIds && !paymentIds.isEmpty()) {
                body = body + ",";
            }
            body = body + "\"invoiceIds\":" + new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString(invoiceIds);
        }
        body = body + "}";
        String response = this.client.post("/v1/invoices/payment/search/", body);
        return InvoicePayment.invoicePaymentsFactory(response);
    }

    public boolean delete(String paymentId, final String invoiceLineId) throws Exception {
        String endPoint = "/v1/invoices/payment/delete/";
        ArrayList<String> invoiceLineIds = new ArrayList<String>(){
            {
                this.add(invoiceLineId);
            }
        };
        String body = "{\"paymentId\":\"" + paymentId + "\",\"invoiceLineIds\":" + new ObjectMapper().writeValueAsString((Object)invoiceLineIds) + "}";
        String response = this.client.post("/v1/invoices/payment/delete/", body);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(response);
        return node.get("ok").asBoolean(false);
    }

    public boolean delete(String paymentId, List<String> invoiceLineIds) throws Exception {
        String endPoint = "/v1/invoices/payment/delete/";
        String body = "{\"paymentId\":\"" + paymentId + "\",\"invoiceLineIds\":" + new ObjectMapper().writeValueAsString(invoiceLineIds) + "}";
        String response = this.client.post("/v1/invoices/payment/delete/", body);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(response);
        return node.get("ok").asBoolean(false);
    }
}

