/*
 * Decompiled with CFR 0.152.
 */
package com.trolley.trolley;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trolley.Exceptions.InvalidFieldException;
import com.trolley.trolley.Client;
import com.trolley.trolley.Configuration;
import com.trolley.trolley.RecipientAccount;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RecipientAccountGateway {
    Client client;

    public RecipientAccountGateway(Configuration config) {
        this.client = new Client(config);
    }

    public List<RecipientAccount> findAll(String recipient_id) throws Exception {
        if (recipient_id == null || recipient_id.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        String endPoint = "/v1/recipients/" + recipient_id + "/accounts";
        String response = this.client.get(endPoint);
        return this.recipientAccountListFactory(response);
    }

    public RecipientAccount find(String recipient_id, String recipient_account_id) throws Exception {
        if (recipient_id == null || recipient_id.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        String endPoint = "/v1/recipients/" + recipient_id + "/accounts/" + recipient_account_id;
        String response = this.client.get(endPoint);
        return this.recipientAccountFactory(response);
    }

    public RecipientAccount create(String recipient_id, String body) throws Exception {
        if (recipient_id == null || recipient_id.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        if (body == null || body.isEmpty()) {
            throw new InvalidFieldException("Body cannot be null or empty");
        }
        String endPoint = "/v1/recipients/" + recipient_id + "/accounts";
        String response = this.client.post(endPoint, body);
        return this.recipientAccountFactory(response);
    }

    public RecipientAccount create(String recipient_id, RecipientAccount account) throws Exception {
        if (recipient_id == null || recipient_id.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        if (account == null) {
            throw new InvalidFieldException("Body cannot be null or empty");
        }
        String jsonAccount = new ObjectMapper().writeValueAsString((Object)account);
        String endPoint = "/v1/recipients/" + recipient_id + "/accounts";
        String response = this.client.post(endPoint, jsonAccount);
        return this.recipientAccountFactory(response);
    }

    public RecipientAccount update(String recipient_id, String recipient_account_id, String body) throws Exception {
        if (recipient_id == null || recipient_id.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        if (body == null || body.isEmpty()) {
            throw new InvalidFieldException("Body cannot be null or empty");
        }
        String endPoint = "/v1/recipients/" + recipient_id + "/accounts/" + recipient_account_id;
        String response = this.client.patch(endPoint, body);
        return this.recipientAccountFactory(response);
    }

    public RecipientAccount update(String recipient_id, String recipient_account_id, RecipientAccount account) throws Exception {
        if (recipient_id == null || recipient_id.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        if (account == null) {
            throw new InvalidFieldException("Body cannot be null or empty");
        }
        String jsonAccount = new ObjectMapper().writeValueAsString((Object)account);
        String endPoint = "/v1/recipients/" + recipient_id + "/accounts/" + recipient_account_id;
        String response = this.client.patch(endPoint, jsonAccount);
        return this.recipientAccountFactory(response);
    }

    public boolean delete(String recipient_id, String recipient_account_id) throws Exception {
        if (recipient_id == null || recipient_id.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        String endPoint = "/v1/recipients/" + recipient_id + "/accounts/" + recipient_account_id;
        this.client.delete(endPoint);
        return true;
    }

    private RecipientAccount recipientAccountFactory(String data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(data);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        RecipientAccount recipientAccount = (RecipientAccount)mapper.readValue(node.get("account").traverse(), RecipientAccount.class);
        return recipientAccount;
    }

    private List<RecipientAccount> recipientAccountListFactory(String data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(data);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object recipientAccount = mapper.readValue(node.get("accounts").traverse(), Object.class);
        List recipAccounts = (List)recipientAccount;
        ArrayList<RecipientAccount> recipientAccounts = new ArrayList<RecipientAccount>();
        for (int i = 0; i < recipAccounts.size(); ++i) {
            RecipientAccount pojo = (RecipientAccount)mapper.convertValue(recipAccounts.get(i), RecipientAccount.class);
            recipientAccounts.add(pojo);
        }
        return recipientAccounts;
    }
}

