/*
 * Decompiled with CFR 0.152.
 */
package com.trolley;

import com.trolley.Client;
import com.trolley.Gateway;
import io.github.cdimascio.dotenv.Dotenv;
import org.apache.http.client.HttpClient;

public class Configuration {
    private String apiBase = "https://api.trolley.com";
    private String privateKey;
    private String publicKey;
    private HttpClient httpClient = null;

    public Configuration() {
        this.privateKey = "";
        this.publicKey = "";
    }

    public Configuration(String publicKey, String privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.apiBase = this.setEnviroment("production");
    }

    public Configuration(String publicKey, String privateKey, HttpClient httpClient) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.httpClient = httpClient;
        this.apiBase = this.setEnviroment("production");
    }

    public Configuration(String publicKey, String privateKey, String apiBase) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.apiBase = this.setEnviroment(apiBase);
    }

    public Configuration(String publicKey, String privateKey, String apiBase, HttpClient httpClient) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.httpClient = httpClient;
        this.apiBase = this.setEnviroment(apiBase);
    }

    public String getApiBase() {
        return this.apiBase;
    }

    public void setEnvironment(String env) {
        this.apiBase = this.setEnviroment(env);
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privatKey) {
        this.privateKey = privatKey;
    }

    public static Gateway gateway() {
        return new Gateway(Configuration.instantiate());
    }

    public static Client client(Configuration config) {
        return new Client(config);
    }

    public static Configuration instantiate() {
        return new Configuration();
    }

    public String setEnviroment(String enviroment) {
        switch (enviroment) {
            case "production": 
            case "PRODUCTION": {
                return "https://api.trolley.com";
            }
            case "development": 
            case "DEVELOPMENT": {
                Dotenv dotenv = Dotenv.load();
                String devBaseUrl = "";
                devBaseUrl = dotenv.get("BASE_URL");
                if (null != devBaseUrl) {
                    if (devBaseUrl.length() == 0) {
                        throw new IllegalArgumentException("No value for BASE_URL was found in .env file while configuration environment specified was 'development'. ");
                    }
                } else {
                    throw new IllegalArgumentException("Parameter BASE_URL was not found in .env file while configuration environment specified was 'development'.");
                }
                return devBaseUrl;
            }
        }
        return "https://api.trolley.com";
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

