/*
 * Decompiled with CFR 0.152.
 */
package com.trolley;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trolley.Client;
import com.trolley.Configuration;
import com.trolley.Exceptions.InvalidFieldException;
import com.trolley.types.Invoice;
import com.trolley.types.Invoices;
import com.trolley.types.supporting.InvoicesIterator;
import java.util.ArrayList;
import java.util.List;

public class InvoiceGateway {
    Client client;

    public InvoiceGateway(Configuration config) {
        this.client = new Client(config);
    }

    public Invoice create(Invoice invoiceBody) throws Exception {
        String body = invoiceBody.toString();
        String endPoint = "/v1/invoices/create/";
        String response = this.client.post("/v1/invoices/create/", body);
        return Invoice.invoiceFactory(response);
    }

    public Invoice update(String invoiceId, Invoice invoiceBody) throws Exception {
        invoiceBody.setInvoiceId(invoiceId);
        String body = invoiceBody.toString();
        String endPoint = "/v1/invoices/update/";
        String response = this.client.post("/v1/invoices/update/", body);
        return Invoice.invoiceFactory(response);
    }

    public boolean delete(final String invoiceId) throws Exception {
        String endPoint = "/v1/invoices/delete/";
        ArrayList<String> invoiceIds = new ArrayList<String>(){
            {
                this.add(invoiceId);
            }
        };
        String body = "{\"invoiceIds\":" + new ObjectMapper().writeValueAsString((Object)invoiceIds) + "}";
        String response = this.client.post("/v1/invoices/delete/", body);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(response);
        return node.get("ok").asBoolean(false);
    }

    public boolean delete(List<String> invoiceIds) throws Exception {
        String endPoint = "/v1/invoices/delete/";
        String body = "{\"invoiceIds\":" + new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString(invoiceIds) + "}";
        String response = this.client.post("/v1/invoices/delete/", body);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(response);
        return node.get("ok").asBoolean(false);
    }

    public Invoice fetch(String invoiceId) throws Exception {
        String endPoint = "/v1/invoices/get/";
        String body = "{\"invoiceId\":\"" + invoiceId + "\"}";
        String response = this.client.post("/v1/invoices/get/", body);
        return Invoice.invoiceFactory(response);
    }

    public InvoicesIterator search(Invoice.SearchBy searchBy, List<String> paramsList, String param) throws Exception {
        int pageSize = 10;
        Invoices invoices = this.search(searchBy, paramsList, param, 1, pageSize);
        return new InvoicesIterator(searchBy, paramsList, param, this, invoices);
    }

    public Invoices search(Invoice.SearchBy searchBy, List<String> paramsList, String param, int page, int pageSize) throws Exception {
        String body = "";
        switch (searchBy) {
            case INVOICE_ID: 
            case RECIPIENT_ID: 
            case INVOICE_NUMBER: 
            case EXTERNAL_ID: 
            case TAGS: {
                if (null == paramsList) {
                    throw new InvalidFieldException("variable paramsList can not be null for the provided searchBy parameter. Refer to method's Javadoc for more details.");
                }
                body = "{\"" + searchBy.getKey() + "\":" + new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString(paramsList) + ", \"page\":" + page + ", \"pageSize\":" + pageSize + "}";
                break;
            }
            case INVOICE_DATE: {
                if (null == param) {
                    throw new InvalidFieldException("variable param can not be null for the provided searchBy parameter. Refer to method's Javadoc for more details.");
                }
                body = "{\"" + searchBy.getKey() + "\":\"" + param + "\"}";
            }
        }
        String endPoint = "/v1/invoices/search/";
        String response = this.client.post("/v1/invoices/search/", body);
        return Invoice.invoiceListFactory(response);
    }
}

