/*
 * Decompiled with CFR 0.152.
 */
package com.trolley;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trolley.Client;
import com.trolley.Configuration;
import com.trolley.Exceptions.InvalidFieldException;
import com.trolley.types.Balances;
import java.util.ArrayList;
import java.util.List;

public class BalancesGateway {
    Client client;

    public BalancesGateway(Configuration config) {
        this.client = new Client(config);
    }

    public List<Balances> getPaypalAccountBalances() throws Exception {
        return this.fetchBalances("paypal");
    }

    public List<Balances> getTrolleyAccountBalances() throws Exception {
        return this.fetchBalances("paymentrails");
    }

    public List<Balances> getAllBalances() throws Exception {
        return this.fetchBalances("");
    }

    private List<Balances> fetchBalances(String accountType) throws Exception {
        if (accountType == null) {
            throw new InvalidFieldException("Account type cannot be null");
        }
        String endPoint = "/v1/balances/" + accountType;
        String response = this.client.get(endPoint);
        return this.balancesListFactory(response);
    }

    private List<Balances> balancesListFactory(String data) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(data);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        List balancesFromResponse = (List)mapper.readValue(node.get("balances").traverse(), Object.class);
        ArrayList<Balances> balances = new ArrayList<Balances>();
        int i = 0;
        while (i < balancesFromResponse.size()) {
            Balances pojo = (Balances)mapper.convertValue(balancesFromResponse.get(i), Balances.class);
            balances.add(pojo);
            ++i;
        }
        return balances;
    }
}

