/*
 * Decompiled with CFR 0.152.
 */
package com.trolley;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trolley.Client;
import com.trolley.Configuration;
import com.trolley.Exceptions.InvalidFieldException;
import com.trolley.types.OfflinePayment;
import com.trolley.types.supporting.Meta;
import com.trolley.types.supporting.OfflinePayments;
import com.trolley.types.supporting.OfflinePaymentsIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OfflinePaymentGateway {
    Client client;

    public OfflinePaymentGateway(Configuration config) {
        this.client = new Client(config);
    }

    public OfflinePayment create(String recipientId, OfflinePayment offlinePayment) throws Exception {
        if (recipientId == null || recipientId.isEmpty()) {
            throw new InvalidFieldException("recipientId cannot be null or empty.");
        }
        if (offlinePayment == null) {
            throw new InvalidFieldException("OfflinePayment request object cannot be null or empty.");
        }
        String jsonRequest = new ObjectMapper().setDefaultPropertyInclusion(JsonInclude.Include.NON_DEFAULT).writeValueAsString((Object)offlinePayment);
        String endPoint = "/v1/recipients/" + recipientId + "/offlinePayments/";
        String response = this.client.post(endPoint, jsonRequest);
        return this.offlinePaymentFactory(response);
    }

    public boolean update(String recipientId, String offlinePaymentId, OfflinePayment offlinePayment) throws Exception {
        if (recipientId == null || recipientId.isEmpty()) {
            throw new InvalidFieldException("recipientId cannot be null or empty.");
        }
        if (offlinePaymentId == null || offlinePaymentId.isEmpty()) {
            throw new InvalidFieldException("offlinePaymentId cannot be null or empty.");
        }
        if (offlinePayment == null) {
            throw new InvalidFieldException("offlinePayment request object cannot be null or empty.");
        }
        String jsonRequest = new ObjectMapper().setDefaultPropertyInclusion(JsonInclude.Include.NON_DEFAULT).writeValueAsString((Object)offlinePayment);
        String endPoint = "/v1/recipients/" + recipientId + "/offlinePayments/" + offlinePaymentId;
        this.client.patch(endPoint, jsonRequest);
        return true;
    }

    public boolean delete(String recipientId, String offlinePaymentId) throws Exception {
        if (recipientId == null || recipientId.isEmpty()) {
            throw new InvalidFieldException("recipientId cannot be null or empty.");
        }
        if (offlinePaymentId == null || offlinePaymentId.isEmpty()) {
            throw new InvalidFieldException("offlinePaymentId cannot be null or empty.");
        }
        String endPoint = "/v1/recipients/" + recipientId + "/offlinePayments/" + offlinePaymentId;
        this.client.delete(endPoint);
        return true;
    }

    public OfflinePaymentsIterator listAllOfflinePayments(String searchTerm) throws Exception {
        if (searchTerm == null) {
            throw new InvalidFieldException("searchTerm cannot be null. If you don't wish to provide a searchTerm, pass a blank String.");
        }
        int pageSize = 10;
        OfflinePayments p = this.listAllOfflinePayments(1, pageSize, searchTerm);
        return new OfflinePaymentsIterator(this, p, searchTerm);
    }

    public OfflinePaymentsIterator listAllOfflinePayments() throws Exception {
        return this.listAllOfflinePayments("");
    }

    public OfflinePayments listAllOfflinePayments(int page, int pageSize, String searchTerm) throws Exception {
        if (page < 0) {
            throw new InvalidFieldException("page cannot be less than 0");
        }
        if (pageSize < 0) {
            throw new InvalidFieldException("pageSize cannot be less than 0");
        }
        if (searchTerm == null) {
            throw new InvalidFieldException("searchTerm cannot be null. If you don't wish to provide a searchTerm, pass a blank String.");
        }
        String endPoint = "/v1/offline-payments?search=" + searchTerm + "&page=" + page + "&pageSize=" + pageSize;
        String response = this.client.get(endPoint);
        return this.offlinePaymentListFactory(response);
    }

    private OfflinePayment offlinePaymentFactory(String data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(data);
        OfflinePayment offlinePayment = (OfflinePayment)mapper.readValue(node.get("offlinePayment").traverse(), OfflinePayment.class);
        return offlinePayment;
    }

    public OfflinePayments offlinePaymentListFactory(String data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(data);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        List paymentsFromResponse = (List)mapper.readValue(node.get("offlinePayments").traverse(), Object.class);
        Meta meta = (Meta)mapper.readValue(node.get("meta").traverse(), Meta.class);
        ArrayList<OfflinePayment> paymentObjs = new ArrayList<OfflinePayment>();
        int i = 0;
        while (i < paymentsFromResponse.size()) {
            OfflinePayment pojo = (OfflinePayment)mapper.convertValue(paymentsFromResponse.get(i), OfflinePayment.class);
            paymentObjs.add(pojo);
            ++i;
        }
        OfflinePayments offlinePayments = new OfflinePayments(paymentObjs, meta);
        return offlinePayments;
    }
}

