/*
 * Decompiled with CFR 0.152.
 */
package com.trolley;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trolley.Client;
import com.trolley.Configuration;
import com.trolley.Exceptions.InvalidFieldException;
import com.trolley.types.Payment;
import com.trolley.types.supporting.Meta;
import com.trolley.types.supporting.Payments;
import com.trolley.types.supporting.PaymentsIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PaymentGateway {
    Client client;

    public PaymentGateway(Configuration config) {
        this.client = new Client(config);
    }

    public Payment find(String paymentId, String batchId) throws Exception {
        if (batchId == null || batchId.isEmpty()) {
            throw new InvalidFieldException("Batch id cannot be null or empty.");
        }
        if (paymentId == null || paymentId.isEmpty()) {
            throw new InvalidFieldException("Payment id cannot be null or empty.");
        }
        String endPoint = "/v1/batches/" + batchId + "/payments/" + paymentId;
        String response = this.client.get(endPoint);
        return this.paymentFactory(response);
    }

    public Payment create(Payment payment, String batchId) throws Exception {
        if (batchId == null || batchId.isEmpty()) {
            throw new InvalidFieldException("Batch id cannot be null or empty.");
        }
        if (payment == null) {
            throw new InvalidFieldException("payment request body cannot be null or empty.");
        }
        String jsonPayment = new ObjectMapper().setDefaultPropertyInclusion(JsonInclude.Include.NON_DEFAULT).writeValueAsString((Object)payment);
        String endPoint = "/v1/batches/" + batchId + "/payments";
        String response = this.client.post(endPoint, jsonPayment);
        return this.paymentFactory(response);
    }

    public boolean update(String paymentId, Payment payment, String batchId) throws Exception {
        if (batchId == null || batchId.isEmpty()) {
            throw new InvalidFieldException("Batch id cannot be null or empty.");
        }
        if (paymentId == null || paymentId.isEmpty()) {
            throw new InvalidFieldException("Payment id cannot be null or empty.");
        }
        if (payment == null) {
            throw new InvalidFieldException("payment request body cannot be null or empty.");
        }
        String jsonPayment = new ObjectMapper().setDefaultPropertyInclusion(JsonInclude.Include.NON_DEFAULT).writeValueAsString((Object)payment);
        String endPoint = "/v1/batches/" + batchId + "/payments/" + paymentId;
        this.client.patch(endPoint, jsonPayment);
        return true;
    }

    public boolean delete(String paymentId, String batchId) throws Exception {
        if (batchId == null || batchId.isEmpty()) {
            throw new InvalidFieldException("Batch id cannot be null or empty.");
        }
        if (paymentId == null || paymentId.isEmpty()) {
            throw new InvalidFieldException("Payment id cannot be null or empty.");
        }
        String endPoint = "/v1/batches/" + batchId + "/payments/" + paymentId;
        this.client.delete(endPoint);
        return true;
    }

    public PaymentsIterator search(String batchId, String searchTerm) throws Exception {
        if (searchTerm == null) {
            throw new InvalidFieldException("searchTerm cannot be null. If you don't wish to provide a searchTerm, pass a blank String.");
        }
        int pageSize = 10;
        Payments p = this.search(batchId, 1, pageSize, searchTerm);
        return new PaymentsIterator(this, p, batchId, searchTerm);
    }

    public Payments search(String batchId, int page, int pageSize, String searchTerm) throws Exception {
        if (batchId == null || batchId.isEmpty()) {
            throw new InvalidFieldException("batchId cannot be null or empty.");
        }
        if (page < 0) {
            throw new InvalidFieldException("page cannot be less than 0");
        }
        if (pageSize < 0) {
            throw new InvalidFieldException("pageSize cannot be less than 0");
        }
        if (searchTerm == null) {
            throw new InvalidFieldException("searchTerm cannot be null. If you don't wish to provide a searchTerm, pass a blank String.");
        }
        String endPoint = "/v1/batches/" + batchId + "/payments?search=" + searchTerm + "&page=" + page + "&pageSize=" + pageSize;
        String response = this.client.get(endPoint);
        return this.paymentListFactory(response);
    }

    private Payment paymentFactory(String data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(data);
        Payment payment = (Payment)mapper.readValue(node.get("payment").traverse(), Payment.class);
        return payment;
    }

    private Payments paymentListFactory(String data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(data);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        List paymentsFromResponse = (List)mapper.readValue(node.get("payments").traverse(), Object.class);
        Meta meta = (Meta)mapper.readValue(node.get("meta").traverse(), Meta.class);
        ArrayList<Payment> paymentObjs = new ArrayList<Payment>();
        int i = 0;
        while (i < paymentsFromResponse.size()) {
            Payment pojo = (Payment)mapper.convertValue(paymentsFromResponse.get(i), Payment.class);
            paymentObjs.add(pojo);
            ++i;
        }
        Payments payments = new Payments(paymentObjs, meta);
        return payments;
    }
}

