/*
 * Decompiled with CFR 0.152.
 */
package com.trolley.types.supporting;

import com.trolley.RecipientGateway;
import com.trolley.types.Log;
import com.trolley.types.supporting.Logs;
import com.trolley.types.supporting.Meta;
import java.util.Iterator;
import java.util.List;

public class LogsIterator
implements Iterator<Log> {
    private RecipientGateway gateway = null;
    private List<Log> logs = null;
    private Meta meta;
    private int index = 0;
    private String recipientId = "";

    public LogsIterator(RecipientGateway gateway, Logs l, String recipientId) {
        this.gateway = gateway;
        this.logs = l.getLogs();
        this.meta = l.getMeta();
        this.recipientId = recipientId;
    }

    @Override
    public boolean hasNext() {
        if (this.index >= this.logs.size()) {
            if (this.meta.getPage() + 1 > this.meta.getPages()) {
                return false;
            }
            return this.fetchNextPage();
        }
        return this.index < this.meta.getRecords();
    }

    @Override
    public Log next() {
        return this.logs.get(this.index++);
    }

    private boolean fetchNextPage() {
        try {
            Logs l = this.gateway.getAllLogs(this.recipientId, this.meta.getPage() + 1, 10);
            this.logs = l.getLogs();
            this.meta = l.getMeta();
            this.index = 0;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

