/*
 * Decompiled with CFR 0.152.
 */
package com.trolley.types.supporting;

import com.trolley.OfflinePaymentGateway;
import com.trolley.RecipientGateway;
import com.trolley.types.OfflinePayment;
import com.trolley.types.supporting.Meta;
import com.trolley.types.supporting.OfflinePayments;
import java.util.Iterator;
import java.util.List;

public class OfflinePaymentsIterator
implements Iterator<OfflinePayment> {
    private OfflinePaymentGateway gateway = null;
    private RecipientGateway recipientGateway = null;
    private List<OfflinePayment> offlinePayments = null;
    private Meta meta;
    private int index = 0;
    private String searchTerm = "";
    private String recipientId = "";

    public OfflinePaymentsIterator(OfflinePaymentGateway gateway, OfflinePayments p, String searchTerm) {
        this.gateway = gateway;
        this.offlinePayments = p.getOfflinePayments();
        this.meta = p.getMeta();
        this.searchTerm = searchTerm;
    }

    public OfflinePaymentsIterator(RecipientGateway gateway, OfflinePayments p, String searchTerm, String recipientId) {
        this.recipientGateway = gateway;
        this.offlinePayments = p.getOfflinePayments();
        this.meta = p.getMeta();
        this.searchTerm = searchTerm;
        this.recipientId = recipientId;
    }

    @Override
    public boolean hasNext() {
        if (this.index >= this.offlinePayments.size()) {
            if (this.meta.getPage() + 1 > this.meta.getPages()) {
                return false;
            }
            return this.fetchNextPage();
        }
        return this.index < this.meta.getRecords();
    }

    @Override
    public OfflinePayment next() {
        return this.offlinePayments.get(this.index++);
    }

    private boolean fetchNextPage() {
        try {
            OfflinePayments p = this.gateway != null ? this.gateway.listAllOfflinePayments(this.meta.getPage() + 1, 10, this.searchTerm) : this.recipientGateway.getAllOfflinePayments(this.recipientId, this.meta.getPage() + 1, 10, this.searchTerm);
            this.offlinePayments = p.getOfflinePayments();
            this.meta = p.getMeta();
            this.index = 0;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

