/*
 * Decompiled with CFR 0.152.
 */
package com.trolley.types.supporting;

import com.trolley.RecipientGateway;
import com.trolley.types.Recipient;
import com.trolley.types.supporting.Meta;
import com.trolley.types.supporting.Recipients;
import java.util.Iterator;
import java.util.List;

public class RecipientsIterator
implements Iterator<Recipient> {
    private RecipientGateway gateway = null;
    private List<Recipient> recipients = null;
    private Meta meta;
    private int index = 0;
    private String searchTerm = "";

    public RecipientsIterator(RecipientGateway gateway, Recipients r, String searchTerm) {
        this.gateway = gateway;
        this.recipients = r.getRecipients();
        this.meta = r.getMeta();
        this.searchTerm = searchTerm;
    }

    @Override
    public boolean hasNext() {
        if (this.index >= this.recipients.size()) {
            if (this.meta.getPage() + 1 > this.meta.getPages()) {
                return false;
            }
            return this.fetchNextPage();
        }
        return this.index < this.meta.getRecords();
    }

    @Override
    public Recipient next() {
        return this.recipients.get(this.index++);
    }

    private boolean fetchNextPage() {
        try {
            Recipients r = this.gateway.search(this.meta.getPage() + 1, 10, this.searchTerm);
            this.recipients = r.getRecipients();
            this.meta = r.getMeta();
            this.index = 0;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

