/*
 * Decompiled with CFR 0.152.
 */
package com.trolley;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trolley.Client;
import com.trolley.Configuration;
import com.trolley.Exceptions.InvalidFieldException;
import com.trolley.types.InvoicePayment;
import com.trolley.types.supporting.InvoicePaymentPart;
import com.trolley.types.supporting.InvoicePaymentRequest;
import com.trolley.types.supporting.InvoicePayments;
import com.trolley.types.supporting.InvoicePaymentsIterator;
import java.util.ArrayList;
import java.util.List;

public class InvoicePaymentGateway {
    Client client;

    public InvoicePaymentGateway(Configuration config) {
        this.client = new Client(config);
    }

    @Deprecated
    public InvoicePayment create(String batchId, final InvoicePaymentPart payment) throws Exception {
        String endPoint = "/v1/invoices/payment/create/";
        String body = "";
        body = null != batchId && !batchId.isEmpty() ? "{ \"batchId\": \"" + batchId + "\"," : "{";
        ArrayList<InvoicePaymentPart> invoicePaymentParts = new ArrayList<InvoicePaymentPart>(){
            {
                this.add(payment);
            }
        };
        body = body + "\"ids\":" + new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString((Object)invoicePaymentParts) + "}";
        String response = this.client.post("/v1/invoices/payment/create/", body);
        return InvoicePayment.invoicePaymentFactory(response);
    }

    @Deprecated
    public InvoicePayment create(String batchId, List<InvoicePaymentPart> invoicePaymentParts) throws Exception {
        String endPoint = "/v1/invoices/payment/create/";
        String body = "";
        body = null != batchId && !batchId.isEmpty() ? "{ \"batchId\": \"" + batchId + "\"," : "{";
        body = body + "\"ids\":" + new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString(invoicePaymentParts) + "}";
        String response = this.client.post("/v1/invoices/payment/create/", body);
        return InvoicePayment.invoicePaymentFactory(response);
    }

    public InvoicePayment create(InvoicePaymentRequest invoicePaymentRequest) throws Exception {
        String endPoint = "/v1/invoices/payment/create/";
        String body = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString((Object)invoicePaymentRequest);
        String response = this.client.post("/v1/invoices/payment/create/", body);
        return InvoicePayment.invoicePaymentFactory(response);
    }

    public boolean update(InvoicePaymentPart invoicePaymentPart) throws Exception {
        String endPoint = "/v1/invoices/payment/update/";
        String body = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString((Object)invoicePaymentPart);
        String response = this.client.post("/v1/invoices/payment/update/", body);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(response);
        return node.get("ok").asBoolean(false);
    }

    public InvoicePaymentsIterator search(List<String> paymentIds, List<String> invoiceIds) throws Exception {
        if (null == invoiceIds && null == paymentIds) {
            throw new InvalidFieldException("Either Invoice IDs or Payment IDs should be present");
        }
        InvoicePayments ip = this.search(paymentIds, invoiceIds, 1, 10);
        return new InvoicePaymentsIterator(this, ip, paymentIds, invoiceIds);
    }

    public InvoicePayments search(List<String> paymentIds, List<String> invoiceIds, int page, int pageSize) throws Exception {
        String endPoint = "/v1/invoices/payment/search/";
        String body = "{";
        if (null != paymentIds && !paymentIds.isEmpty()) {
            body = body + "\"paymentIds\":" + new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString(paymentIds);
        }
        if (null != invoiceIds && !invoiceIds.isEmpty()) {
            if (null != paymentIds && !paymentIds.isEmpty()) {
                body = body + ",";
            }
            body = body + "\"invoiceIds\":" + new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString(invoiceIds);
        }
        body = body + ", \"page\":" + page;
        body = body + ", \"pageSize\":" + pageSize;
        body = body + "}";
        String response = this.client.post("/v1/invoices/payment/search/", body);
        return InvoicePayment.invoicePaymentsFactory(response);
    }

    public boolean delete(String paymentId, final String invoiceLineId) throws Exception {
        String endPoint = "/v1/invoices/payment/delete/";
        ArrayList<String> invoiceLineIds = new ArrayList<String>(){
            {
                this.add(invoiceLineId);
            }
        };
        String body = "{\"paymentId\":\"" + paymentId + "\",\"invoiceLineIds\":" + new ObjectMapper().writeValueAsString((Object)invoiceLineIds) + "}";
        String response = this.client.post("/v1/invoices/payment/delete/", body);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(response);
        return node.get("ok").asBoolean(false);
    }

    public boolean delete(String paymentId, List<String> invoiceLineIds) throws Exception {
        String endPoint = "/v1/invoices/payment/delete/";
        String body = "{\"paymentId\":\"" + paymentId + "\",\"invoiceLineIds\":" + new ObjectMapper().writeValueAsString(invoiceLineIds) + "}";
        String response = this.client.post("/v1/invoices/payment/delete/", body);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(response);
        return node.get("ok").asBoolean(false);
    }
}

