/*
 * Decompiled with CFR 0.152.
 */
package com.trolley;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trolley.Client;
import com.trolley.Configuration;
import com.trolley.Exceptions.InvalidFieldException;
import com.trolley.types.RecipientAccount;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RecipientAccountGateway {
    Client client;

    public RecipientAccountGateway(Configuration config) {
        this.client = new Client(config);
    }

    public List<RecipientAccount> findAll(String recipientId) throws Exception {
        if (recipientId == null || recipientId.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        String endPoint = "/v1/recipients/" + recipientId + "/accounts";
        String response = this.client.get(endPoint);
        return this.recipientAccountListFactory(response);
    }

    public RecipientAccount find(String recipientId, String recipientAccountId) throws Exception {
        if (recipientId == null || recipientId.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        String endPoint = "/v1/recipients/" + recipientId + "/accounts/" + recipientAccountId;
        String response = this.client.get(endPoint);
        return this.recipientAccountFactory(response);
    }

    public RecipientAccount create(String recipientId, RecipientAccount account) throws Exception {
        if (recipientId == null || recipientId.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        if (account == null) {
            throw new InvalidFieldException("Body cannot be null or empty");
        }
        String jsonAccount = new ObjectMapper().setDefaultPropertyInclusion(JsonInclude.Include.NON_DEFAULT).writeValueAsString((Object)account);
        String endPoint = "/v1/recipients/" + recipientId + "/accounts";
        String response = this.client.post(endPoint, jsonAccount);
        return this.recipientAccountFactory(response);
    }

    public RecipientAccount update(String recipientId, String recipientAccountId, RecipientAccount account) throws Exception {
        if (recipientId == null || recipientId.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        if (account == null) {
            throw new InvalidFieldException("Body cannot be null or empty");
        }
        String jsonAccount = new ObjectMapper().setDefaultPropertyInclusion(JsonInclude.Include.NON_DEFAULT).writeValueAsString((Object)account);
        String endPoint = "/v1/recipients/" + recipientId + "/accounts/" + recipientAccountId;
        String response = this.client.patch(endPoint, jsonAccount);
        return this.recipientAccountFactory(response);
    }

    public boolean delete(String recipientId, String recipientAccountId) throws Exception {
        if (recipientId == null || recipientId.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        String endPoint = "/v1/recipients/" + recipientId + "/accounts/" + recipientAccountId;
        this.client.delete(endPoint);
        return true;
    }

    private RecipientAccount recipientAccountFactory(String data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(data);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        RecipientAccount recipientAccount = (RecipientAccount)mapper.readValue(node.get("account").traverse(), RecipientAccount.class);
        return recipientAccount;
    }

    private List<RecipientAccount> recipientAccountListFactory(String data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(data);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object recipientAccount = mapper.readValue(node.get("accounts").traverse(), Object.class);
        List recipAccounts = (List)recipientAccount;
        ArrayList<RecipientAccount> recipientAccounts = new ArrayList<RecipientAccount>();
        int i = 0;
        while (i < recipAccounts.size()) {
            RecipientAccount pojo = (RecipientAccount)mapper.convertValue(recipAccounts.get(i), RecipientAccount.class);
            recipientAccounts.add(pojo);
            ++i;
        }
        return recipientAccounts;
    }
}

