/*
 * Decompiled with CFR 0.152.
 */
package com.trolley;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trolley.Client;
import com.trolley.Configuration;
import com.trolley.Exceptions.InvalidFieldException;
import com.trolley.OfflinePaymentGateway;
import com.trolley.types.Log;
import com.trolley.types.Payment;
import com.trolley.types.Recipient;
import com.trolley.types.supporting.Logs;
import com.trolley.types.supporting.LogsIterator;
import com.trolley.types.supporting.Meta;
import com.trolley.types.supporting.OfflinePayments;
import com.trolley.types.supporting.OfflinePaymentsIterator;
import com.trolley.types.supporting.Recipients;
import com.trolley.types.supporting.RecipientsIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RecipientGateway {
    Client client;

    public RecipientGateway(Configuration config) {
        this.client = new Client(config);
    }

    public Recipient find(String recipientId) throws Exception {
        if (recipientId == null || recipientId.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        String endPoint = "/v1/recipients/" + recipientId;
        String response = this.client.get(endPoint);
        return this.recipientFactory(response);
    }

    public Logs getAllLogs(String recipientId, int page, int pageSize) throws Exception {
        if (recipientId == null) {
            throw new InvalidFieldException("recipientId cannot be null.");
        }
        String endPoint = "/v1/recipients/" + recipientId + "/logs?page=" + page + "&pageSize=" + pageSize;
        String response = this.client.get(endPoint);
        return this.logListFactory(response);
    }

    public LogsIterator getAllLogs(String recipientId) throws Exception {
        if (recipientId == null) {
            throw new InvalidFieldException("recipientId cannot be null.");
        }
        int pageSize = 10;
        Logs p = this.getAllLogs(recipientId, 1, pageSize);
        return new LogsIterator(this, p, recipientId);
    }

    public List<Payment> findPayments(String recipientId) throws Exception {
        if (recipientId == null || recipientId.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        String endPoint = "/v1/recipients/" + recipientId + "/payments";
        String response = this.client.get(endPoint);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(response);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object payment = mapper.readValue(node.get("payments").traverse(), Object.class);
        List paymens = (List)payment;
        ArrayList<Payment> payments = new ArrayList<Payment>();
        int i = 0;
        while (i < paymens.size()) {
            Payment pojo = (Payment)mapper.convertValue(paymens.get(i), Payment.class);
            payments.add(pojo);
            ++i;
        }
        return payments;
    }

    public Recipient create(Recipient recipient) throws Exception {
        if (recipient == null) {
            throw new InvalidFieldException("Recipient object cannot be null or empty");
        }
        String jsonRecipient = new ObjectMapper().setDefaultPropertyInclusion(JsonInclude.Include.NON_DEFAULT).writeValueAsString((Object)recipient);
        String endPoint = "/v1/recipients/";
        String response = this.client.post("/v1/recipients/", jsonRecipient);
        return this.recipientFactory(response);
    }

    public boolean update(String recipientId, Recipient recipient) throws Exception {
        if (recipientId == null || recipientId.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        if (recipient == null) {
            throw new InvalidFieldException("Recipient object cannot be null or empty");
        }
        String jsonRecipient = new ObjectMapper().writeValueAsString((Object)recipient);
        String endPoint = "/v1/recipients/" + recipientId;
        this.client.patch(endPoint, jsonRecipient);
        return true;
    }

    public boolean delete(String recipientId) throws Exception {
        if (recipientId == null || recipientId.isEmpty()) {
            throw new InvalidFieldException("Recipient id cannot be null or empty.");
        }
        String endPoint = "/v1/recipients/" + recipientId;
        this.client.delete(endPoint);
        return true;
    }

    public boolean delete(List<Recipient> recipients) throws Exception {
        if (recipients == null || recipients.isEmpty()) {
            throw new InvalidFieldException("Recipient list cannot be null or empty.");
        }
        String endPoint = "/v1/recipients/";
        String body = "{\"ids\" : [";
        int i = 0;
        while (i < recipients.size()) {
            body = String.valueOf(body) + new ObjectMapper().writeValueAsString((Object)recipients.get(i).getId());
            if (i < recipients.size() - 1) {
                body = String.valueOf(body) + ",";
            }
            ++i;
        }
        body = String.valueOf(body) + "]}";
        this.client.delete("/v1/recipients/", body);
        return true;
    }

    public OfflinePaymentsIterator getAllOfflinePayments(String recipientId, String searchTerm) throws Exception {
        if (recipientId == null) {
            throw new InvalidFieldException("recipientId cannot be null.");
        }
        if (searchTerm == null) {
            throw new InvalidFieldException("searchTerm cannot be null. If you don't wish to provide a searchTerm, pass a blank String.");
        }
        int pageSize = 10;
        OfflinePayments p = this.getAllOfflinePayments(recipientId, 1, pageSize, searchTerm);
        return new OfflinePaymentsIterator(this, p, searchTerm, recipientId);
    }

    public OfflinePayments getAllOfflinePayments(String recipientId, int page, int pageSize, String searchTerm) throws Exception {
        if (recipientId == null) {
            throw new InvalidFieldException("recipientId cannot be null.");
        }
        if (searchTerm == null) {
            throw new InvalidFieldException("searchTerm cannot be null. If you don't wish to provide a searchTerm, pass a blank String.");
        }
        String endPoint = "/v1/recipients/" + recipientId + "/offlinePayments?search=" + searchTerm + "&page=" + page + "&pageSize=" + pageSize;
        String response = this.client.get(endPoint);
        OfflinePaymentGateway opGateway = new OfflinePaymentGateway(null);
        return opGateway.offlinePaymentListFactory(response);
    }

    public RecipientsIterator search(String searchTerm) throws Exception {
        if (searchTerm == null) {
            throw new InvalidFieldException("searchTerm cannot be null. If you don't wish to provide a searchTerm, pass a blank String.");
        }
        int pageSize = 10;
        Recipients r = this.search(1, pageSize, searchTerm);
        return new RecipientsIterator(this, r, searchTerm);
    }

    public Recipients search(int page, int pageSize, String searchTerm) throws Exception {
        if (page < 0) {
            throw new InvalidFieldException("page cannot be less than 0.");
        }
        if (pageSize < 0) {
            throw new InvalidFieldException("pageSize cannot be less than 0.");
        }
        if (searchTerm == null) {
            throw new InvalidFieldException("searchTerm cannot be null. If you don't wish to provide a searchTerm, pass a blank String.");
        }
        try {
            String endPoint = "/v1/recipients/?&search=" + searchTerm + "&page=" + page + "&pageSize=" + pageSize;
            String response = this.client.get(endPoint);
            return this.recipientListFactory(response);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Recipient recipientFactory(String data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(data);
        Recipient recipient = (Recipient)mapper.readValue(node.get("recipient").traverse(), Recipient.class);
        return recipient;
    }

    private Logs logListFactory(String data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(data);
        List logsFromResponse = (List)mapper.readValue(node.get("recipientLogs").traverse(), Object.class);
        Meta meta = (Meta)mapper.readValue(node.get("meta").traverse(), Meta.class);
        Logs logs = new Logs(new ArrayList<Log>(), meta);
        int i = 0;
        while (i < logsFromResponse.size()) {
            Log pojo = (Log)mapper.convertValue(logsFromResponse.get(i), Log.class);
            logs.getLogs().add(pojo);
            ++i;
        }
        return logs;
    }

    private Recipients recipientListFactory(String data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(data);
        List recips = (List)mapper.readValue(node.get("recipients").traverse(), Object.class);
        Meta meta = (Meta)mapper.readValue(node.get("meta").traverse(), Meta.class);
        Recipients recipients = new Recipients(new ArrayList<Recipient>(), meta);
        int i = 0;
        while (i < recips.size()) {
            Recipient pojo = (Recipient)mapper.convertValue(recips.get(i), Recipient.class);
            recipients.getRecipients().add(pojo);
            ++i;
        }
        return recipients;
    }
}

