/*
 * Decompiled with CFR 0.152.
 */
package com.trolley.types.supporting;

import com.trolley.BatchGateway;
import com.trolley.types.Batch;
import com.trolley.types.supporting.Batches;
import com.trolley.types.supporting.Meta;
import java.util.Iterator;
import java.util.List;

public class BatchesIterator
implements Iterator<Batch> {
    private BatchGateway gateway = null;
    private List<Batch> batches = null;
    private Meta meta;
    private int index = 0;
    private String searchTerm = "";

    public BatchesIterator(BatchGateway gateway, Batches b, String searchTerm) {
        this.gateway = gateway;
        this.batches = b.getBatches();
        this.meta = b.getMeta();
        this.searchTerm = searchTerm;
    }

    @Override
    public boolean hasNext() {
        if (this.index >= this.batches.size()) {
            if (this.meta.getPage() + 1 > this.meta.getPages()) {
                return false;
            }
            return this.fetchNextPage();
        }
        return this.index < this.meta.getRecords();
    }

    @Override
    public Batch next() {
        return this.batches.get(this.index++);
    }

    private boolean fetchNextPage() {
        try {
            Batches b = this.gateway.search(this.meta.getPage() + 1, 10, this.searchTerm);
            this.batches = b.getBatches();
            this.meta = b.getMeta();
            this.index = 0;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

