/*
 * Decompiled with CFR 0.152.
 */
package com.trolley.types.supporting;

import com.trolley.PaymentGateway;
import com.trolley.types.Payment;
import com.trolley.types.supporting.Meta;
import com.trolley.types.supporting.Payments;
import java.util.Iterator;
import java.util.List;

public class PaymentsIterator
implements Iterator<Payment> {
    private PaymentGateway gateway = null;
    private List<Payment> payments = null;
    private Meta meta;
    private int index = 0;
    private String searchTerm = "";
    private String batchId = "";

    public PaymentsIterator(PaymentGateway gateway, Payments p, String batchId, String searchTerm) {
        this.gateway = gateway;
        this.payments = p.getPayments();
        this.meta = p.getMeta();
        this.batchId = batchId;
        this.searchTerm = searchTerm;
    }

    @Override
    public boolean hasNext() {
        if (this.index >= this.payments.size()) {
            if (this.meta.getPage() + 1 > this.meta.getPages()) {
                return false;
            }
            return this.fetchNextPage();
        }
        return this.index < this.meta.getRecords();
    }

    @Override
    public Payment next() {
        return this.payments.get(this.index++);
    }

    private boolean fetchNextPage() {
        try {
            Payments p = this.gateway.search(this.batchId, this.meta.getPage() + 1, 10, this.searchTerm);
            this.payments = p.getPayments();
            this.meta = p.getMeta();
            this.index = 0;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

