/*
 * Decompiled with CFR 0.152.
 */
package com.trolley;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trolley.Client;
import com.trolley.Configuration;
import com.trolley.Exceptions.InvalidFieldException;
import com.trolley.types.Batch;
import com.trolley.types.Payment;
import com.trolley.types.supporting.BatchSummary;
import com.trolley.types.supporting.Batches;
import com.trolley.types.supporting.BatchesIterator;
import com.trolley.types.supporting.Meta;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BatchGateway {
    Client client;

    public BatchGateway(Configuration config) {
        this.client = new Client(config);
    }

    public Batch find(String batchId) throws Exception {
        if (batchId == null || batchId.isEmpty()) {
            throw new InvalidFieldException("Batch id cannot be null or empty.");
        }
        String endPoint = "/v1/batches/" + batchId;
        String response = this.client.get(endPoint);
        return this.batchFactory(response);
    }

    public boolean update(String batchId, Batch batch) throws Exception {
        if (batchId == null || batchId.isEmpty()) {
            throw new InvalidFieldException("Batch id cannot be null or empty.");
        }
        if (batch == null) {
            throw new InvalidFieldException("Batch object cannot be null or empty.");
        }
        String jsonBatch = new ObjectMapper().writeValueAsString((Object)batch);
        String endPoint = "/v1/batches/" + batchId;
        this.client.patch(endPoint, jsonBatch);
        return true;
    }

    public boolean delete(String batchId) throws Exception {
        if (batchId == null || batchId.isEmpty()) {
            throw new InvalidFieldException("Batch id cannot be null or empty.");
        }
        String endPoint = "/v1/batches/" + batchId;
        this.client.delete(endPoint);
        return true;
    }

    public boolean delete(List<Batch> batches) throws Exception {
        if (batches == null || batches.isEmpty()) {
            throw new InvalidFieldException("batches cannot be null or empty.");
        }
        String endPoint = "/v1/batches";
        String body = "{\"ids\" : [";
        for (int i = 0; i < batches.size(); ++i) {
            body = body + new ObjectMapper().writeValueAsString((Object)batches.get(i).getId());
            if (i >= batches.size() - 1) continue;
            body = body + ",";
        }
        body = body + "]}";
        this.client.delete("/v1/batches", body);
        return true;
    }

    public Batch create(Batch batch) throws Exception {
        if (batch == null) {
            throw new InvalidFieldException("Batch cannot be null.");
        }
        String body = new ObjectMapper().writeValueAsString((Object)batch);
        String endPoint = "/v1/batches/";
        String response = this.client.post("/v1/batches/", body);
        return this.batchFactory(response);
    }

    public String generateQuote(String batchId) throws Exception {
        if (batchId == null || batchId.isEmpty()) {
            throw new InvalidFieldException("Batch id cannot be null or empty.");
        }
        String endPoint = "/v1/batches/" + batchId + "/generate-quote";
        String response = this.client.post(endPoint);
        return response;
    }

    public String processBatch(String batchId) throws Exception {
        if (batchId == null || batchId.isEmpty()) {
            throw new InvalidFieldException("Batch id cannot be null or empty.");
        }
        String endPoint = "/v1/batches/" + batchId + "/start-processing";
        String response = this.client.post(endPoint);
        return response;
    }

    public BatchesIterator search(String searchTerm) throws Exception {
        if (searchTerm == null) {
            throw new InvalidFieldException("searchTerm cannot be null. If you don't wish to provide a searchTerm, pass a blank String.");
        }
        int pageSize = 10;
        Batches b = this.search(1, pageSize, searchTerm);
        return new BatchesIterator(this, b, searchTerm);
    }

    public Batches search(int page, int pageSize, String searchTerm) throws Exception {
        if (page < 0) {
            throw new InvalidFieldException("page cannot be less than 0");
        }
        if (pageSize < 0) {
            throw new InvalidFieldException("pageSize cannot be less than 0");
        }
        if (searchTerm == null) {
            throw new InvalidFieldException("searchTerm cannot be null. If you don't wish to provide a searchTerm, pass a blank String.");
        }
        String endPoint = "/v1/batches/?&search=" + searchTerm + "&page=" + page + "&pageSize=" + pageSize;
        String response = this.client.get(endPoint);
        return this.batchListFactory(response);
    }

    public BatchSummary summary(String batchId) throws Exception {
        if (batchId == null || batchId.isEmpty()) {
            throw new InvalidFieldException("Batch id cannot be null os empty");
        }
        String endPoint = "/v1/batches/" + batchId + "/summary";
        String response = this.client.get(endPoint);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(response);
        BatchSummary batchSummary = (BatchSummary)mapper.readValue(node.get("batchSummary").traverse(), BatchSummary.class);
        return batchSummary;
    }

    private Batch batchFactory(String data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(data);
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object payments = mapper.readValue(node.get("batch").get("payments").get("payments").traverse(), Object.class);
        List castPayments = (List)payments;
        ArrayList<Payment> paymentList = new ArrayList<Payment>();
        for (int i = 0; i < castPayments.size(); ++i) {
            Payment payment = (Payment)mapper.convertValue(castPayments.get(i), Payment.class);
            paymentList.add(payment);
        }
        Batch batch = (Batch)mapper.readValue(node.get("batch").traverse(), Batch.class);
        batch.setPayments(paymentList);
        return batch;
    }

    private Batches batchListFactory(String data) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(data);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        List batchesFromResponse = (List)mapper.readValue(node.get("batches").traverse(), Object.class);
        Meta meta = (Meta)mapper.readValue(node.get("meta").traverse(), Meta.class);
        ArrayList<Batch> batches = new ArrayList<Batch>();
        for (int i = 0; i < batchesFromResponse.size(); ++i) {
            Batch pojo = (Batch)mapper.convertValue(batchesFromResponse.get(i), Batch.class);
            batches.add(pojo);
        }
        return new Batches(batches, meta);
    }
}

