/*
 * Decompiled with CFR 0.152.
 */
package com.trolley;

import com.trolley.Configuration;
import com.trolley.Exceptions.AuthenticationException;
import com.trolley.Exceptions.AuthorizationException;
import com.trolley.Exceptions.DownForMaintenanceException;
import com.trolley.Exceptions.InvalidServerConnectionException;
import com.trolley.Exceptions.InvalidStatusCodeException;
import com.trolley.Exceptions.MalformedException;
import com.trolley.Exceptions.NotFoundException;
import com.trolley.Exceptions.TooManyRequestsException;
import com.trolley.Exceptions.UnexpectedException;
import com.trolley.Version;
import com.trolley.types.supporting.HttpDeleteWithBody;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;

public class Client {
    private Configuration config;
    private String trolleySourceString = "java-sdk_" + Version.MAJOR + "." + Version.MINOR + "." + Version.PATCH;

    public Client(Configuration config) {
        this.config = config;
    }

    public static Client create(Configuration config) {
        return new Client(config);
    }

    private HttpClient getHttpClient() {
        if (null != this.config.getHttpClient()) {
            return this.config.getHttpClient();
        }
        return HttpClients.createSystem();
    }

    public String get(String endpoint) throws Exception {
        HttpClient httpclient = this.getHttpClient();
        HttpGet httpGet = new HttpGet(this.config.getApiBase() + endpoint);
        httpGet.setHeaders(this.getHeaders("GET", endpoint, ""));
        HttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
        return this.processResponse(response);
    }

    public String post(String endpoint, String body) throws Exception {
        HttpClient httpclient = this.getHttpClient();
        HttpPost httpPatch = new HttpPost(this.config.getApiBase() + endpoint);
        StringEntity params = new StringEntity(body);
        httpPatch.setEntity((HttpEntity)params);
        httpPatch.setHeaders(this.getHeaders("POST", endpoint, body));
        HttpResponse response = httpclient.execute((HttpUriRequest)httpPatch);
        return this.processResponse(response);
    }

    public String post(String endpoint) throws Exception {
        HttpClient httpclient = this.getHttpClient();
        HttpPost httpPatch = new HttpPost(this.config.getApiBase() + endpoint);
        StringEntity params = new StringEntity("");
        httpPatch.setEntity((HttpEntity)params);
        httpPatch.setHeaders(this.getHeaders("POST", endpoint, ""));
        HttpResponse response = httpclient.execute((HttpUriRequest)httpPatch);
        return this.processResponse(response);
    }

    public String patch(String endpoint, String body) throws Exception {
        HttpClient httpclient = this.getHttpClient();
        HttpPatch httpPatch = new HttpPatch(this.config.getApiBase() + endpoint);
        StringEntity params = new StringEntity(body);
        httpPatch.setEntity((HttpEntity)params);
        httpPatch.setHeaders(this.getHeaders("PATCH", endpoint, body));
        HttpResponse response = httpclient.execute((HttpUriRequest)httpPatch);
        return this.processResponse(response);
    }

    public String delete(String endpoint) throws Exception {
        HttpClient httpclient = this.getHttpClient();
        HttpDelete httpDelete = new HttpDelete(this.config.getApiBase() + endpoint);
        httpDelete.setHeaders(this.getHeaders("DELETE", endpoint, ""));
        HttpResponse response = httpclient.execute((HttpUriRequest)httpDelete);
        return this.processResponse(response);
    }

    public String delete(String endpoint, String body) throws Exception {
        HttpClient httpclient = this.getHttpClient();
        HttpDeleteWithBody httpDeleteWithBody = new HttpDeleteWithBody(this.config.getApiBase() + endpoint);
        StringEntity params = new StringEntity(body);
        httpDeleteWithBody.setEntity((HttpEntity)params);
        httpDeleteWithBody.setHeaders(this.getHeaders("DELETE", endpoint, body));
        HttpResponse response = httpclient.execute((HttpUriRequest)httpDeleteWithBody);
        return this.processResponse(response);
    }

    private void throwStatusCodeException(int statusCode, String message) throws Exception {
        switch (statusCode) {
            case 400: {
                throw new MalformedException(message);
            }
            case 401: {
                throw new AuthenticationException(message);
            }
            case 403: {
                throw new AuthorizationException(message);
            }
            case 404: {
                throw new NotFoundException(statusCode + " " + message);
            }
            case 406: {
                throw new InvalidStatusCodeException(message);
            }
            case 429: {
                throw new TooManyRequestsException(message);
            }
            case 500: {
                throw new InvalidServerConnectionException(message);
            }
            case 503: {
                throw new DownForMaintenanceException(message);
            }
        }
        throw new UnexpectedException(message);
    }

    private String generateAuthorization(int timeStamp, String method, String endPoint, String body) {
        String message = timeStamp + "\n" + method + "\n" + endPoint + "\n" + body + "\n";
        try {
            String hash = this.hmacDigest(message, this.config.getPrivateKey(), "HmacSHA256");
            return "prsign " + this.config.getPublicKey() + ":" + hash;
        }
        catch (Exception e) {
            return "prsign 1:1";
        }
    }

    private String hmacDigest(String msg, String keyString, String algo) throws Exception {
        String digest = null;
        SecretKeySpec key = new SecretKeySpec(keyString.getBytes("UTF-8"), algo);
        Mac mac = Mac.getInstance(algo);
        mac.init(key);
        byte[] bytes = mac.doFinal(msg.getBytes("ASCII"));
        StringBuffer hash = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                hash.append('0');
            }
            hash.append(hex);
        }
        digest = hash.toString();
        return digest;
    }

    String processResponse(HttpResponse response) throws Exception {
        String responseStr = "";
        try {
            StringBuffer result = new StringBuffer();
            String line = "";
            BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            responseStr = result.toString();
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                this.throwStatusCodeException(responseCode, responseStr);
            }
        }
        catch (IOException e) {
            throw new java.rmi.UnexpectedException(responseStr);
        }
        return responseStr;
    }

    private Header[] getHeaders(String method, String endpoint, String body) {
        int timestamp = (int)(System.currentTimeMillis() / 1000L);
        String authorizarion = this.generateAuthorization(timestamp, method, endpoint, body);
        return new Header[]{new BasicHeader("Content-Type", "application/json"), new BasicHeader("X-PR-Timestamp", "" + timestamp), new BasicHeader("Authorization", authorizarion), new BasicHeader("Trolley-Source", this.trolleySourceString)};
    }
}

