/*
 * Decompiled with CFR 0.152.
 */
package com.trolley;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trolley.Client;
import com.trolley.Configuration;
import com.trolley.Exceptions.InvalidFieldException;
import com.trolley.types.Invoice;
import com.trolley.types.InvoiceLine;
import java.util.ArrayList;
import java.util.List;

public class InvoiceLineGateway {
    Client client;

    public InvoiceLineGateway(Configuration config) {
        this.client = new Client(config);
    }

    public Invoice create(String invoiceId, final InvoiceLine invoiceLine) throws Exception {
        String endPoint = "/v1/invoices/create-lines/";
        ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>(this){
            final /* synthetic */ InvoiceLineGateway this$0;
            {
                this.this$0 = this$0;
                this.add(invoiceLine);
            }
        };
        String body = "{\"invoiceId\":\"" + invoiceId + "\",\"lines\":" + new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString((Object)invoiceLines) + "}";
        String response = this.client.post("/v1/invoices/create-lines/", body);
        return InvoiceLine.invoiceLinesFactory(response);
    }

    public Invoice create(String invoiceId, List<InvoiceLine> invoiceLines) throws Exception {
        String endPoint = "/v1/invoices/create-lines/";
        String body = "{\"invoiceId\":\"" + invoiceId + "\",\"lines\":" + new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString(invoiceLines) + "}";
        String response = this.client.post("/v1/invoices/create-lines/", body);
        return InvoiceLine.invoiceLinesFactory(response);
    }

    public Invoice update(String invoiceId, final InvoiceLine invoiceLine) throws Exception {
        String endPoint = "/v1/invoices/update-lines/";
        if (null == invoiceLine.getInvoiceLineId() || invoiceLine.getInvoiceLineId().length() == 0) {
            throw new InvalidFieldException("invoiceLineId of invoiceLine object must be set to denote which invoiceLine needs to be updated. Did you set id variable instead? Refer to method's Javadoc for more details.");
        }
        ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>(this){
            final /* synthetic */ InvoiceLineGateway this$0;
            {
                this.this$0 = this$0;
                this.add(invoiceLine);
            }
        };
        String body = "{\"invoiceId\":\"" + invoiceId + "\",\"lines\" :" + new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString((Object)invoiceLines) + "}";
        String response = this.client.post("/v1/invoices/update-lines/", body);
        return InvoiceLine.invoiceLinesFactory(response);
    }

    public Invoice update(String invoiceId, List<InvoiceLine> invoiceLines) throws Exception {
        String endPoint = "/v1/invoices/update-lines/";
        for (InvoiceLine invoiceLine : invoiceLines) {
            if (null != invoiceLine.getInvoiceLineId() && invoiceLine.getInvoiceLineId().length() != 0) continue;
            throw new InvalidFieldException("invoiceLineId of invoiceLine object must be set to denote which invoiceLine needs to be updated. Please confirm all of the items have this set correctly. Refer to method's Javadoc for more details.");
        }
        String body = "{\"invoiceId\":\"" + invoiceId + "\",\"lines\":" + new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString(invoiceLines) + "}";
        String response = this.client.post("/v1/invoices/update-lines/", body);
        return InvoiceLine.invoiceLinesFactory(response);
    }

    public boolean delete(String invoiceId, final String invoiceLineId) throws Exception {
        String endPoint = "/v1/invoices/delete-lines/";
        ArrayList<String> invoiceLineIds = new ArrayList<String>(this){
            final /* synthetic */ InvoiceLineGateway this$0;
            {
                this.this$0 = this$0;
                this.add(invoiceLineId);
            }
        };
        String body = "{\"invoiceId\":\"" + invoiceId + "\",\"invoiceLineIds\":" + new ObjectMapper().writeValueAsString((Object)invoiceLineIds) + "}";
        String response = this.client.post("/v1/invoices/delete-lines/", body);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(response);
        return node.get("ok").asBoolean(false);
    }

    public boolean delete(String invoiceId, List<String> invoiceLineIds) throws Exception {
        String endPoint = "/v1/invoices/delete-lines/";
        String body = "{\"invoiceId\":\"" + invoiceId + "\",\"invoiceLineIds\":" + new ObjectMapper().writeValueAsString(invoiceLineIds) + "}";
        String response = this.client.post("/v1/invoices/delete-lines/", body);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonNode node = mapper.readTree(response);
        return node.get("ok").asBoolean(false);
    }
}

