/*
 * Decompiled with CFR 0.152.
 */
package com.trolley.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.trolley.types.Invoice;
import com.trolley.types.supporting.Amount;
import java.util.List;
import java.util.Locale;

public class InvoiceLine {
    private String id;
    private String invoiceLineId;
    private String status;
    private String description;
    private Amount unitAmount;
    private String quantity;
    private Amount discountAmount;
    private Amount taxAmount;
    private Amount totalAmount;
    private Amount dueAmount;
    private Amount paidAmount;
    private String externalId;
    private Boolean taxReportable;
    private List<String> tags;
    private InvoiceCategories category;
    private Boolean forceUsTaxActivity;

    public InvoiceLine() {
    }

    public InvoiceLine(Amount unitAmount, InvoiceCategories category, String description, String externalId, Boolean taxReportable, Boolean forceUsTaxActivity, List<String> tags, String quantity, Amount discountAmount, Amount taxAmount, Amount dueAmount, Amount paidAmount) {
        this.description = description;
        this.unitAmount = unitAmount;
        this.quantity = quantity;
        this.discountAmount = discountAmount;
        this.taxAmount = taxAmount;
        this.dueAmount = dueAmount;
        this.paidAmount = paidAmount;
        this.externalId = externalId;
        this.taxReportable = taxReportable;
        this.tags = tags;
        this.category = category;
        this.forceUsTaxActivity = forceUsTaxActivity;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getInvoiceLineId() {
        return this.invoiceLineId;
    }

    public void setInvoiceLineId(String invoiceLineId) {
        this.invoiceLineId = invoiceLineId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Amount getUnitAmount() {
        return this.unitAmount;
    }

    public void setUnitAmount(Amount unitAmount) {
        this.unitAmount = unitAmount;
    }

    public String getQuantity() {
        return this.quantity;
    }

    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    public Amount getDiscountAmount() {
        return this.discountAmount;
    }

    public void setDiscountAmount(Amount discountAmount) {
        this.discountAmount = discountAmount;
    }

    public Amount getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(Amount taxAmount) {
        this.taxAmount = taxAmount;
    }

    public Amount getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Amount totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Amount getDueAmount() {
        return this.dueAmount;
    }

    public void setDueAmount(Amount dueAmount) {
        this.dueAmount = dueAmount;
    }

    public Amount getPaidAmount() {
        return this.paidAmount;
    }

    public void setPaidAmount(Amount paidAmount) {
        this.paidAmount = paidAmount;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Boolean isTaxReportable() {
        return this.taxReportable;
    }

    public void setTaxReportable(Boolean taxReportable) {
        this.taxReportable = taxReportable;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public InvoiceCategories getCategory() {
        return this.category;
    }

    public void setCategory(InvoiceCategories category) {
        this.category = category;
    }

    public Boolean isForceUsTaxActivity() {
        return this.forceUsTaxActivity;
    }

    public void setForceUsTaxActivity(Boolean forceUsTaxActivity) {
        this.forceUsTaxActivity = forceUsTaxActivity;
    }

    public static Invoice invoiceLinesFactory(String invoiceLineResponse) throws JsonMappingException, JsonProcessingException {
        return Invoice.invoiceFactory(invoiceLineResponse);
    }

    public String toString() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        String jsonString = null;
        try {
            jsonString = objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return jsonString;
    }

    public static enum InvoiceCategories {
        SERVICES("services"),
        RENT("rent"),
        ROYALTIES("royalties"),
        ROYALTIES_FILM("royalties_film"),
        PRIZES("prizes"),
        EDUCATION("education"),
        REFUNDS("refunds");

        private String key;

        private InvoiceCategories(String key) {
            this.key = key;
        }

        @JsonCreator
        public static InvoiceCategories fromString(String key) {
            return key == null ? null : InvoiceCategories.valueOf(key.toUpperCase(Locale.US));
        }

        @JsonValue
        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.key.toLowerCase(Locale.US);
        }
    }
}

