/*
 * Decompiled with CFR 0.152.
 */
package com.trolley.types.supporting;

import com.trolley.InvoicePaymentGateway;
import com.trolley.types.supporting.InvoicePaymentPart;
import com.trolley.types.supporting.InvoicePayments;
import com.trolley.types.supporting.Meta;
import java.util.Iterator;
import java.util.List;

public class InvoicePaymentsIterator
implements Iterator<InvoicePaymentPart> {
    private InvoicePaymentGateway gateway = null;
    private List<InvoicePaymentPart> paymentParts = null;
    private Meta meta;
    private int index = 0;
    final List<String> paymentIds = null;
    final List<String> invoiceIds = null;

    public InvoicePaymentsIterator(InvoicePaymentGateway gateway, InvoicePayments ip, List<String> paymentIds, List<String> invoiceIds) {
        this.gateway = gateway;
        this.paymentParts = ip.getInvoicePaymentParts();
        this.meta = ip.getMeta();
    }

    @Override
    public boolean hasNext() {
        if (this.index >= this.paymentParts.size()) {
            if (this.meta.getPage() + 1 > this.meta.getPages()) {
                return false;
            }
            return this.fetchNextPage();
        }
        return this.index < this.meta.getRecords();
    }

    @Override
    public InvoicePaymentPart next() {
        return this.paymentParts.get(this.index++);
    }

    private boolean fetchNextPage() {
        try {
            InvoicePayments ip = this.gateway.search(this.paymentIds, this.invoiceIds, this.meta.getPage() + 1, 10);
            this.paymentParts = ip.getInvoicePaymentParts();
            this.meta = ip.getMeta();
            this.index = 0;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

