/*
 * Decompiled with CFR 0.152.
 */
package com.trolley.types.supporting;

import com.trolley.InvoiceGateway;
import com.trolley.types.Invoice;
import com.trolley.types.Invoices;
import com.trolley.types.supporting.Meta;
import java.util.Iterator;
import java.util.List;

public class InvoicesIterator
implements Iterator<Invoice> {
    private InvoiceGateway gateway = null;
    private List<Invoice> invoices = null;
    private Meta meta = null;
    private Invoice.SearchBy searchBy = null;
    private List<String> paramsList = null;
    private String param = null;
    private int index = 0;

    public InvoicesIterator(Invoice.SearchBy searchBy, List<String> paramsList, String param, InvoiceGateway gateway, Invoices i) {
        this.searchBy = searchBy;
        this.paramsList = paramsList;
        this.param = param;
        this.gateway = gateway;
        this.invoices = i.getInvoices();
        this.meta = i.getMeta();
    }

    @Override
    public boolean hasNext() {
        if (this.index >= this.invoices.size()) {
            if (this.meta.getPage() + 1 > this.meta.getPages()) {
                return false;
            }
            return this.fetchNextPage();
        }
        return this.index < this.meta.getRecords();
    }

    @Override
    public Invoice next() {
        return this.invoices.get(this.index++);
    }

    private boolean fetchNextPage() {
        try {
            Invoices i = this.gateway.search(this.searchBy, this.paramsList, this.param, this.meta.getPage() + 1, 10);
            this.invoices = i.getInvoices();
            this.meta = i.getMeta();
            this.index = 0;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

