/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.apiclient.Attachments;
import com.versionone.apiclient.ConnectionException;
import com.versionone.apiclient.IAPIConnector;
import com.versionone.apiclient.IAttachments;
import com.versionone.apiclient.ILocalizer;
import com.versionone.apiclient.IMetaModel;
import com.versionone.apiclient.IServices;
import com.versionone.apiclient.IV1Configuration;
import com.versionone.apiclient.Localizer;
import com.versionone.apiclient.MetaModel;
import com.versionone.apiclient.ProxyProvider;
import com.versionone.apiclient.Services;
import com.versionone.apiclient.V1APIConnector;
import com.versionone.apiclient.V1Configuration;
import com.versionone.om.ApplicationUnavailableException;
import com.versionone.om.AuthenticationException;
import com.versionone.om.CookiesManager;
import com.versionone.om.ProxySettings;
import com.versionone.om.V1ConnectionValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiClientInternals {
    private static final String CONFIG_PARAM = "config.v1/";
    private static final String ATTACHMENT_PARAM = "attachment.img/";
    private static final String REST_PARAM = "rest-1.v1/";
    private static final String LOC_PARAM = "loc.v1/";
    private static final String META_PARAM = "meta.v1/";
    private final String applicationPath;
    private final String username;
    private final String password;
    private final ProxySettings proxySettings;
    private IMetaModel metaModel;
    private IServices services;
    private ILocalizer loc;
    private IAttachments attachments;
    private IV1Configuration v1Config;
    private final DeligatorDictionary customHttpHeaders = new DeligatorDictionary();

    ApiClientInternals(String applicationPath) {
        this(applicationPath, null, null);
    }

    ApiClientInternals(String applicationPath, String username, String password) {
        this(applicationPath, username, password, null);
    }

    public ApiClientInternals(String applicationPath, String username, String password, ProxySettings proxySettings) {
        this.applicationPath = applicationPath;
        this.username = username;
        this.password = password;
        this.proxySettings = proxySettings;
    }

    String getApplicationPath() {
        return this.applicationPath;
    }

    public IMetaModel getMetaModel() {
        if (this.metaModel == null) {
            V1APIConnector connector = new V1APIConnector(this.applicationPath + META_PARAM, ApiClientInternals.getProxyProvider(this.proxySettings));
            this.customHttpHeaders.add(connector);
            this.metaModel = new MetaModel((IAPIConnector)connector);
        }
        return this.metaModel;
    }

    public ILocalizer getLocalizer() {
        if (this.loc == null) {
            V1APIConnector connector = new V1APIConnector(this.applicationPath + LOC_PARAM, ApiClientInternals.getProxyProvider(this.proxySettings));
            this.customHttpHeaders.add(connector);
            this.loc = new Localizer((IAPIConnector)connector);
        }
        return this.loc;
    }

    public IServices getServices() {
        if (this.services == null) {
            V1APIConnector connector = new V1APIConnector(this.applicationPath + REST_PARAM, this.username, this.password, ApiClientInternals.getProxyProvider(this.proxySettings));
            this.customHttpHeaders.add(connector);
            this.services = new Services(this.getMetaModel(), (IAPIConnector)connector);
        }
        return this.services;
    }

    public IAttachments getAttachments() {
        if (this.attachments == null) {
            V1APIConnector connector = new V1APIConnector(this.applicationPath + ATTACHMENT_PARAM, this.username, this.password, ApiClientInternals.getProxyProvider(this.proxySettings));
            this.customHttpHeaders.add(connector);
            this.attachments = new Attachments((IAPIConnector)connector);
        }
        return this.attachments;
    }

    public IV1Configuration getV1Config() {
        if (this.v1Config == null) {
            V1APIConnector connector = new V1APIConnector(this.applicationPath + CONFIG_PARAM, ApiClientInternals.getProxyProvider(this.proxySettings));
            this.customHttpHeaders.add(connector);
            this.v1Config = new V1Configuration((IAPIConnector)connector);
        }
        return this.v1Config;
    }

    void validate() throws ApplicationUnavailableException, AuthenticationException {
        V1ConnectionValidator validator = new V1ConnectionValidator(this.applicationPath, this.username, this.password, this.proxySettings);
        for (String key : this.customHttpHeaders.keySet()) {
            validator.getCustomHttpHeaders().put(key, (String)this.customHttpHeaders.get(key));
        }
        try {
            validator.checkConnection();
        }
        catch (ConnectionException e) {
            throw new ApplicationUnavailableException("Unable to connect to VersionOne.", e);
        }
        try {
            validator.checkAuthentication();
        }
        catch (ConnectionException e) {
            throw new AuthenticationException("Invalid username or password.", e);
        }
    }

    public static ProxyProvider getProxyProvider(ProxySettings proxySettings) {
        if (proxySettings == null) {
            return null;
        }
        return new ProxyProvider(proxySettings.getAddress(), proxySettings.getUserName(), proxySettings.getPassword());
    }

    public Map<String, String> getCustomHttpHeaders() {
        return this.customHttpHeaders;
    }

    public CookiesManager getCookiesJar() {
        return new CookiesManager(this.applicationPath, this.username, this.password);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeligatorDictionary
    extends HashMap<String, String> {
        private List<V1APIConnector> connectors = new ArrayList<V1APIConnector>();

        private DeligatorDictionary() {
        }

        public void add(V1APIConnector connector) {
            connector.customHttpHeaders.putAll(this);
            this.connectors.add(connector);
        }

        @Override
        public String put(String key, String value) {
            for (V1APIConnector connector : this.connectors) {
                connector.customHttpHeaders.put(key, value);
            }
            return super.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            for (String string : m.keySet()) {
                this.put(string, m.get(string));
            }
            super.putAll(m);
        }

        @Override
        public void clear() {
            for (V1APIConnector connector : this.connectors) {
                connector.customHttpHeaders.clear();
            }
            super.clear();
        }

        @Override
        public String remove(Object key) {
            for (V1APIConnector connector : this.connectors) {
                connector.customHttpHeaders.remove(key);
            }
            return (String)super.remove(key);
        }
    }
}

