/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.om.ApplicationUnavailableException;
import com.versionone.om.AssetID;
import com.versionone.om.AttachmentLengthExceededException;
import com.versionone.om.BaseAsset;
import com.versionone.om.Entity;
import com.versionone.om.IListValueProperty;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.MetaRenamedAttribute;
import com.versionone.om.V1Instance;
import com.versionone.om.listvalue.AttachmentType;
import com.versionone.util.V1Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@MetaDataAttribute(value="Attachment")
public class Attachment
extends Entity {
    Attachment(V1Instance instance) {
        super(instance);
        this.set("Content", "");
    }

    Attachment(AssetID id, V1Instance instance) {
        super(id, instance);
    }

    public String getURL() {
        return this.getEntityURL();
    }

    public String getContentURL() {
        return this.getInstance().getAttachmentURL(this);
    }

    public BaseAsset getAsset() {
        return this.getRelation(BaseAsset.class, "Asset");
    }

    public void setAsset(BaseAsset asset) {
        this.setRelation("Asset", asset);
    }

    public String getDescription() {
        return (String)this.get("Description");
    }

    public void setDescription(String description) {
        this.set("Description", description);
    }

    public String getContentType() {
        return (String)this.get("ContentType");
    }

    public void setContentType(String contentType) {
        this.set("ContentType", contentType);
    }

    public String getFilename() {
        return (String)this.get("Filename");
    }

    public void setFilename(String filename) {
        this.set("Filename", filename);
    }

    public String getName() {
        return (String)this.get("Name");
    }

    public void setName(String name) {
        this.set("Name", name);
    }

    @MetaRenamedAttribute(value="Category")
    public IListValueProperty getType() {
        return this.getListValue(AttachmentType.class, "Category");
    }

    public void writeTo(OutputStream output) throws ApplicationUnavailableException {
        InputStream input = this.getInstance().getReader(this);
        try {
            V1Util.copyStream(input, output);
        }
        catch (IOException e) {
            throw new ApplicationUnavailableException(e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void readFrom(InputStream input) throws ApplicationUnavailableException, AttachmentLengthExceededException {
        OutputStream output = null;
        try {
            output = this.getInstance().getWriter(this, this.getContentType());
            V1Util.copyStream(input, output);
            this.getInstance().commitWriteStream(this);
        }
        catch (IOException e) {
            throw new ApplicationUnavailableException(e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean canDelete() {
        return this.getInstance().canExecuteOperation(this, "Delete");
    }

    public void delete() {
        this.save();
        this.getInstance().executeOperation(this, "Delete");
    }
}

