/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.DB;
import com.versionone.om.ApplicationUnavailableException;
import com.versionone.om.AssetID;
import com.versionone.om.DataException;
import com.versionone.om.EntityCollection;
import com.versionone.om.ICustomAttributeDictionary;
import com.versionone.om.ICustomDropdownDictionary;
import com.versionone.om.IListValueProperty;
import com.versionone.om.Member;
import com.versionone.om.Rank;
import com.versionone.om.StubAssetID;
import com.versionone.om.V1Instance;
import com.versionone.om.filters.EntityFilter;
import com.versionone.om.listvalue.CustomListValue;
import com.versionone.om.listvalue.ListValue;
import com.versionone.util.V1Util;
import java.util.Collection;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Entity {
    protected static final String DESCRIPTION_VALUE = "Description";
    protected static final String ASSET_VALUE = "Asset";
    protected static final String ASSET_STATE_VALUE = "AssetState";
    protected static final String CONTENT_TYPE_VALUE = "ContentType";
    protected static final String FILENAME_VALUE = "Filename";
    protected static final String NAME_VALUE = "Name";
    protected static final String CONTENT_VALUE = "Content";
    public static final String CREATE_DATE_UTC = "CreateDateUTC";
    public static final String CHANGE_DATE_UTC = "ChangeDateUTC";
    protected static final String DELETE_OPERATION = "Delete";
    private V1Instance instance;
    private AssetID assetID;
    private StubAssetID stubAssetID;

    protected V1Instance getInstance() {
        return this.instance;
    }

    protected Entity(AssetID id, V1Instance instance) {
        this.assetID = id;
        this.instance = instance;
    }

    protected Entity(V1Instance instance) {
        this.stubAssetID = new StubAssetID();
        this.instance = instance;
    }

    public AssetID getID() {
        return this.assetID;
    }

    Object getInstanceKey() {
        return this.assetID != null ? this.assetID : this.stubAssetID;
    }

    public DB.DateTime getChangeDate() {
        return new DB.DateTime(DB.DateTime.convertUtcToLocal((Date)this.get(CHANGE_DATE_UTC, true)));
    }

    public String getChangeComment() {
        return (String)this.get("ChangeComment", false);
    }

    public Member getChangedBy() {
        return this.getRelation(Member.class, "ChangedBy", false);
    }

    public DB.DateTime getCreateDate() {
        return new DB.DateTime(DB.DateTime.convertUtcToLocal((Date)this.get(CREATE_DATE_UTC, true)));
    }

    public String getCreateComment() {
        return (String)this.get("CreateComment", true);
    }

    public Member getCreatedBy() {
        return this.getRelation(Member.class, "CreatedBy", true);
    }

    String getEntityURL() {
        return this.instance.getEntityURL(this);
    }

    protected Object get(String name) {
        return this.instance.getProperty(this, name, true);
    }

    Object get(String name, boolean cachable) {
        return this.instance.getProperty(this, name, cachable);
    }

    void set(String name, Object value) {
        this.instance.setProperty(this, name, value);
    }

    void clearCache(String name) {
        this.instance.clearCache(this, name);
    }

    Double getSum(String multiRelationName, EntityFilter filter, String numericAttributeName) {
        return this.instance.getSum(this, multiRelationName, filter, numericAttributeName);
    }

    Rank<? extends Entity> getRank(String attributeName) {
        return this.instance.getRank(this, attributeName);
    }

    <T extends Entity> T getRelation(Class<T> valuesClass, String name) {
        return this.getRelation(valuesClass, name, true);
    }

    <T extends Entity> T getRelation(Class<T> valuesClass, String name, boolean cachable) {
        return this.instance.getRelation(this, valuesClass, name, cachable);
    }

    void setRelation(String name, Entity value) {
        this.instance.setRelation(this, name, value);
    }

    <T extends Entity> EntityCollection<T> getMultiRelation(String name) {
        return this.getMultiRelation(name, true);
    }

    <T extends Entity> EntityCollection<T> getMultiRelation(String name, boolean cachable) {
        return this.instance.getMultiRelation(this, name, cachable);
    }

    public void save(String comment) throws DataException, ApplicationUnavailableException {
        this.assetID = this.instance.commit(this, comment);
        this.stubAssetID = null;
    }

    public void save() throws DataException, ApplicationUnavailableException {
        this.save(null);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Entity) {
            Entity other = (Entity)obj;
            return V1Util.equals(this.assetID, other.assetID) && V1Util.equals(this.stubAssetID, other.stubAssetID);
        }
        return false;
    }

    public int hashCode() {
        return this.getInstanceKey().hashCode();
    }

    public String toString() {
        return this.getID().toString();
    }

    <T extends ListValue> T getListRelation(Class<T> valuesClass, String name) {
        return (T)((ListValue)this.getRelation(valuesClass, name, true));
    }

    <T extends ListValue> void setListRelation(String attributeName, String value, Class<T> valuesClass) {
        this.instance.setListRelation(this, attributeName, value, valuesClass);
    }

    CustomListValue getCustomListValue(String attributeName) {
        return this.instance.getCustomRelation(this, attributeName);
    }

    void setCustomListRelation(String name, String value) {
        this.instance.setCustomListRelation(this, name, value);
    }

    boolean containsAttribute(String attributeName) {
        return this.instance.isAttributeExists(this, attributeName);
    }

    <T extends ListValue> Collection<T> getListTypeValues(Class<T> valuesClass) {
        return this.instance.get().listTypeValues(valuesClass);
    }

    <T extends ListValue> IListValueProperty getListValue(Class<T> valuesClass, String name) {
        return new ListValueProperty<T>(valuesClass, name);
    }

    Collection<CustomListValue> getCustomListTypeValues(String attributeName) {
        return this.instance.getCustomListTypeValues(this, attributeName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CustomListValueProperty
    extends BaseListValueProperty<CustomListValue> {
        public CustomListValueProperty(String attributeName) {
            super("Custom_" + attributeName);
        }

        @Override
        public String getCurrentValue() {
            CustomListValue value = Entity.this.getCustomListValue(this.attributeName);
            if (value != null) {
                return value.getName();
            }
            return null;
        }

        @Override
        public void setCurrentValue(String value) {
            Entity.this.setCustomListRelation(this.attributeName, value);
        }

        public Collection<CustomListValue> getValues() {
            return Entity.this.getCustomListTypeValues(this.attributeName);
        }

        @Override
        protected Collection<CustomListValue> items() {
            return this.getValues();
        }

        @Override
        public void clearCurrentValue() {
            Entity.this.setRelation(this.attributeName, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ListValueProperty<T extends ListValue>
    extends BaseListValueProperty<T> {
        private final Class<T> valuesClass;

        ListValueProperty(Class<T> valuesClass, String attributeName) {
            super(attributeName);
            this.valuesClass = valuesClass;
        }

        @Override
        public String getCurrentValue() {
            T value = this.getSelectedValue();
            if (value != null) {
                return ((ListValue)value).toString();
            }
            return null;
        }

        @Override
        public void setCurrentValue(String value) {
            Entity.this.setListRelation(this.attributeName, value, this.valuesClass);
        }

        public Collection<T> getValues() {
            return Entity.this.getListTypeValues(this.valuesClass);
        }

        @Override
        protected Collection<T> items() {
            return this.getValues();
        }

        private T getSelectedValue() {
            return Entity.this.getListRelation(this.valuesClass, this.attributeName);
        }

        @Override
        public void clearCurrentValue() {
            Entity.this.setRelation(this.attributeName, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class BaseListValueProperty<T extends ListValue>
    implements IListValueProperty {
        protected final String attributeName;

        BaseListValueProperty(String attributeName) {
            this.attributeName = attributeName;
        }

        public String toString() {
            return this.getCurrentValue();
        }

        @Override
        public abstract String getCurrentValue();

        @Override
        public abstract void setCurrentValue(String var1);

        @Override
        public String[] getAllValues() {
            String[] res = new String[this.items().size()];
            int i = 0;
            for (ListValue value : this.items()) {
                res[i++] = value.getName();
            }
            return res;
        }

        protected abstract Collection<T> items();

        @Override
        public boolean isValid(String value) {
            if (value == null) {
                return true;
            }
            for (ListValue item : this.items()) {
                if (!item.getName().equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public abstract void clearCurrentValue();
    }

    class ListCustomAttributeDictionary
    implements ICustomDropdownDictionary {
        public IListValueProperty get(String attributeName) {
            return new CustomListValueProperty(attributeName);
        }

        public boolean containsKey(String attributeName) {
            return Entity.this.containsAttribute("Custom_" + attributeName);
        }
    }

    class SimpleCustomAttributeDictionary
    implements ICustomAttributeDictionary {
        public Object get(String attributeName) {
            return Entity.this.get("Custom_" + attributeName);
        }

        public void set(String attributeName, Object attributeValue) {
            Entity.this.set("Custom_" + attributeName, attributeValue);
        }

        public Double getNumeric(String attributeName) {
            return (Double)this.get(attributeName);
        }

        public Boolean getBoolean(String attributeName) {
            return (Boolean)this.get(attributeName);
        }

        public DB.DateTime getDate(String attributeName) {
            return new DB.DateTime(this.get(attributeName));
        }

        public String getString(String attributeName) {
            return (String)this.get(attributeName);
        }

        public boolean containsKey(String attributeName) {
            return Entity.this.containsAttribute("Custom_" + attributeName);
        }
    }
}

