/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.DB;
import com.versionone.om.AssetID;
import com.versionone.om.BaseAsset;
import com.versionone.om.Issue;
import com.versionone.om.Iteration;
import com.versionone.om.Member;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.Project;
import com.versionone.om.Story;
import com.versionone.om.Team;
import com.versionone.om.V1Instance;
import com.versionone.om.filters.IssueFilter;
import com.versionone.om.filters.StoryFilter;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MetaDataAttribute(value="Retrospective")
public class Retrospective
extends BaseAsset {
    Retrospective(AssetID id, V1Instance instance) {
        super(id, instance);
    }

    Retrospective(V1Instance instance) {
        super(instance);
    }

    @Override
    void closeImpl() {
        this.getInstance().executeOperation(this, "Inactivate");
    }

    @Override
    void reactivateImpl() {
        this.getInstance().executeOperation(this, "Reactivate");
    }

    public Project getProject() {
        return this.getRelation(Project.class, "Scope");
    }

    public void setProject(Project value) {
        this.setRelation("Scope", value);
    }

    public Collection<Story> getIdentifiedStories(StoryFilter filter) {
        filter = filter != null ? filter : new StoryFilter();
        filter.identifiedIn.clear();
        filter.identifiedIn.add(this);
        return this.getInstance().get().story(filter);
    }

    public Collection<Issue> getIssues(IssueFilter filter) {
        filter = filter != null ? filter : new IssueFilter();
        filter.retrospective.clear();
        filter.retrospective.add(this);
        return this.getInstance().get().issues(filter);
    }

    public Member getFacilitatedBy() {
        return this.getRelation(Member.class, "FacilitatedBy");
    }

    public void setFacilitatedBy(Member value) {
        this.setRelation("FacilitatedBy", value);
    }

    public Iteration getIteration() {
        return this.getRelation(Iteration.class, "Timebox");
    }

    public void setIteration(Iteration value) {
        this.setRelation("Timebox", value);
    }

    public DB.DateTime getDate() {
        return new DB.DateTime(this.get("Date"));
    }

    public void setDate(DB.DateTime value) {
        this.set("Date", value.getDate());
    }

    public Team getTeam() {
        return this.getRelation(Team.class, "Team");
    }

    public void setTeam(Team value) {
        this.setRelation("Team", value);
    }

    public String getSummary() {
        return (String)this.get("Summary");
    }

    public void setSummary(String value) {
        this.set("Summary", value);
    }

    public Story createStory(String name) {
        return this.getInstance().create().story(name, this);
    }

    public Story createStory(String name, Map<String, Object> attribute) {
        return this.getInstance().create().story(name, this, attribute);
    }

    public Issue createIssue(String name) {
        return this.getInstance().create().issue(name, this);
    }

    public Issue createIssue(String name, Map<String, Object> attributes) {
        return this.getInstance().create().issue(name, this, attributes);
    }
}

