/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.om.AssetID;
import com.versionone.om.BaseAsset;
import com.versionone.om.Effort;
import com.versionone.om.Issue;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.PrimaryWorkitem;
import com.versionone.om.Retrospective;
import com.versionone.om.V1Instance;
import com.versionone.om.filters.EffortFilter;
import com.versionone.om.filters.IssueFilter;
import com.versionone.om.filters.PrimaryWorkitemFilter;
import com.versionone.om.filters.RetrospectiveFilter;
import com.versionone.om.filters.WorkitemFilter;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MetaDataAttribute(value="Team")
public class Team
extends BaseAsset {
    Team(AssetID id, V1Instance instance) {
        super(id, instance);
    }

    Team(V1Instance instance) {
        super(instance);
    }

    public Collection<PrimaryWorkitem> getPrimaryWorkitems(PrimaryWorkitemFilter filter) {
        filter = filter == null ? new PrimaryWorkitemFilter() : filter;
        filter.team.clear();
        filter.team.add(this);
        return this.getInstance().get().primaryWorkitems(filter);
    }

    public Collection<Issue> getIssues(IssueFilter filter) {
        filter = filter == null ? new IssueFilter() : filter;
        filter.team.clear();
        filter.team.add(this);
        return this.getInstance().get().issues(filter);
    }

    public Collection<Retrospective> getRetrospectives(RetrospectiveFilter filter) {
        filter = filter == null ? new RetrospectiveFilter() : filter;
        filter.team.clear();
        filter.team.add(this);
        return this.getInstance().get().retrospectives(filter);
    }

    public Collection<Effort> getEffortRecords(EffortFilter filter) {
        filter = filter == null ? new EffortFilter() : filter;
        filter.team.clear();
        filter.team.add(this);
        return this.getInstance().get().effortRecords(filter);
    }

    @Override
    void closeImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Inactivate");
    }

    @Override
    void reactivateImpl() throws UnsupportedOperationException {
        this.getInstance().executeOperation(this, "Reactivate");
    }

    public Double getTotalEstimate(PrimaryWorkitemFilter filter) {
        filter = filter == null ? new PrimaryWorkitemFilter() : filter;
        return this.getSum("Workitems:PrimaryWorkitem", filter, "Estimate");
    }

    public Double getTotalDone(WorkitemFilter filter) {
        filter = filter == null ? new WorkitemFilter() : filter;
        return this.getSum("Workitems", filter, "Actuals.Value");
    }

    public Double getTotalDetailEstimate(WorkitemFilter filter) {
        filter = filter == null ? new WorkitemFilter() : filter;
        return this.getSum("Workitems", filter, "DetailEstimate");
    }

    public Double getTotalToDo(WorkitemFilter filter) {
        filter = filter == null ? new WorkitemFilter() : filter;
        return this.getSum("Workitems", filter, "ToDo");
    }
}

