/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.DB;
import com.versionone.Duration;
import com.versionone.apiclient.MimeType;
import com.versionone.om.ApplicationUnavailableException;
import com.versionone.om.AssetID;
import com.versionone.om.Attachment;
import com.versionone.om.AttachmentLengthExceededException;
import com.versionone.om.BaseAsset;
import com.versionone.om.BuildProject;
import com.versionone.om.BuildRun;
import com.versionone.om.ChangeSet;
import com.versionone.om.Conversation;
import com.versionone.om.Defect;
import com.versionone.om.Effort;
import com.versionone.om.Entity;
import com.versionone.om.Environment;
import com.versionone.om.Epic;
import com.versionone.om.Expression;
import com.versionone.om.Goal;
import com.versionone.om.Issue;
import com.versionone.om.Iteration;
import com.versionone.om.Link;
import com.versionone.om.Member;
import com.versionone.om.Message;
import com.versionone.om.Note;
import com.versionone.om.PrimaryWorkitem;
import com.versionone.om.Project;
import com.versionone.om.RegressionPlan;
import com.versionone.om.RegressionSuite;
import com.versionone.om.RegressionTest;
import com.versionone.om.Request;
import com.versionone.om.Retrospective;
import com.versionone.om.Role;
import com.versionone.om.Schedule;
import com.versionone.om.Story;
import com.versionone.om.Task;
import com.versionone.om.Team;
import com.versionone.om.Test;
import com.versionone.om.TestSet;
import com.versionone.om.TestSuite;
import com.versionone.om.Theme;
import com.versionone.om.V1Instance;
import com.versionone.om.Workitem;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V1InstanceCreator {
    private final V1Instance instance;

    V1InstanceCreator(V1Instance instance) {
        this.instance = instance;
    }

    public Project project(String name, Project parentProject, DB.DateTime beginDate, Schedule schedule) {
        return this.project(name, parentProject, beginDate, schedule, null);
    }

    public Project project(String name, Project parentProject, DB.DateTime beginDate, Schedule schedule, Map<String, Object> attributes) {
        Project project = new Project(this.instance);
        project.setName(name);
        project.setParentProject(parentProject);
        project.setBeginDate(beginDate);
        project.setSchedule(schedule);
        this.addAttributes(project, attributes);
        project.save();
        return project;
    }

    public Project project(String name, AssetID parentProjectID, DB.DateTime beginDate, Schedule schedule) {
        return this.project(name, new Project(parentProjectID, this.instance), beginDate, schedule, null);
    }

    public Project project(String name, AssetID parentProjectID, DB.DateTime beginDate, Schedule schedule, Map<String, Object> attributes) {
        return this.project(name, new Project(parentProjectID, this.instance), beginDate, schedule, attributes);
    }

    public Member member(String name, String shortName, Role defaultRole) {
        return this.member(name, shortName, defaultRole, null);
    }

    public Member member(String name, String shortName, Role defaultRole, Map<String, Object> attributes) {
        Member member = new Member(this.instance);
        member.setName(name);
        member.setShortName(shortName);
        member.setDefaultRole(defaultRole);
        this.addAttributes(member, attributes);
        member.save();
        return member;
    }

    public Member member(String name, String shortName) {
        return this.member(name, shortName, Role.TEAM_MEMBER);
    }

    public Member member(String name, String shortName, Map<String, Object> attributes) {
        return this.member(name, shortName, Role.TEAM_MEMBER, attributes);
    }

    public Team team(String name) {
        return this.team(name, null);
    }

    public Team team(String name, Map<String, Object> attributes) {
        Team team = new Team(this.instance);
        team.setName(name);
        this.addAttributes(team, attributes);
        team.save();
        return team;
    }

    public Story story(String name, Project project) {
        return this.story(name, project, null);
    }

    public Story story(String name, Project project, Map<String, Object> attributes) {
        Story story = new Story(this.instance);
        story.setName(name);
        story.setProject(project);
        this.addAttributes(story, attributes);
        story.save();
        return story;
    }

    public Story story(String name, Retrospective retrospective) {
        return this.story(name, retrospective, null);
    }

    public Story story(String name, Retrospective retrospective, Map<String, Object> attributes) {
        Story story = new Story(this.instance);
        story.setName(name);
        story.setIdentifiedIn(retrospective);
        story.setProject(retrospective.getProject());
        this.addAttributes(story, attributes);
        story.save();
        return story;
    }

    public Defect defect(String name, Project project) {
        return this.defect(name, project, null);
    }

    public Defect defect(String name, Project project, Map<String, Object> attributes) {
        Defect defect = new Defect(this.instance);
        defect.setName(name);
        defect.setProject(project);
        this.addAttributes(defect, attributes);
        defect.save();
        return defect;
    }

    public Task task(String name, PrimaryWorkitem primaryWorkitem) {
        return this.task(name, primaryWorkitem, null);
    }

    public Task task(String name, PrimaryWorkitem primaryWorkitem, Map<String, Object> attributes) {
        Task task = new Task(this.instance);
        task.setName(name);
        task.setParent(primaryWorkitem);
        this.addAttributes(task, attributes);
        task.save();
        return task;
    }

    public Test test(String name, Workitem workitem) {
        return this.test(name, workitem, null);
    }

    public Test test(String name, Workitem workitem, Map<String, Object> attributes) {
        Test test = new Test(this.instance);
        test.setName(name);
        test.setParent(workitem);
        this.addAttributes(test, attributes);
        test.save();
        return test;
    }

    public Theme theme(String name, Project project) {
        return this.theme(name, project, null);
    }

    public Theme theme(String name, Project project, Map<String, Object> attributes) {
        Theme theme = new Theme(this.instance);
        theme.setName(name);
        theme.setProject(project);
        this.addAttributes(theme, attributes);
        theme.save();
        return theme;
    }

    public Goal goal(String name, Project project) {
        return this.goal(name, project, null);
    }

    public Goal goal(String name, Project project, Map<String, Object> attributes) {
        Goal goal = new Goal(this.instance);
        goal.setName(name);
        goal.setProject(project);
        this.addAttributes(goal, attributes);
        goal.save();
        return goal;
    }

    public Issue issue(String name, Project project) {
        return this.issue(name, project, null);
    }

    public Issue issue(String name, Project project, Map<String, Object> attributes) {
        Issue issue = new Issue(this.instance);
        issue.setName(name);
        issue.setProject(project);
        this.addAttributes(issue, attributes);
        issue.save();
        return issue;
    }

    public Issue issue(String name, Retrospective retrospective) {
        return this.issue(name, retrospective, null);
    }

    public Issue issue(String name, Retrospective retrospective, Map<String, Object> attributes) {
        Issue issue = new Issue(this.instance);
        issue.setName(name);
        issue.setProject(retrospective.getProject());
        this.addAttributes(issue, attributes);
        issue.save();
        issue.getRetrospectives().add(retrospective);
        return issue;
    }

    public Request request(String name, Project project) {
        return this.request(name, project, null);
    }

    public Request request(String name, Project project, Map<String, Object> attributes) {
        Request request = new Request(this.instance);
        request.setName(name);
        request.setProject(project);
        this.addAttributes(request, attributes);
        request.save();
        return request;
    }

    public Epic epic(String name, Project project) {
        return this.epic(name, project, null);
    }

    public Epic epic(String name, Project project, Map<String, Object> attributes) {
        Epic epic = new Epic(this.instance);
        epic.setName(name);
        epic.setProject(project);
        this.addAttributes(epic, attributes);
        epic.save();
        return epic;
    }

    public Link link(String name, BaseAsset asset, String url, boolean onMenu) {
        return this.link(name, asset, url, onMenu, null);
    }

    public Link link(String name, BaseAsset asset, String url, boolean onMenu, Map<String, Object> attributes) {
        Link link = new Link(this.instance);
        link.setAsset(asset);
        link.setName(name);
        link.setURL(url);
        link.setOnMenu(onMenu);
        this.addAttributes(link, attributes);
        link.save();
        return link;
    }

    public Note note(String name, BaseAsset asset, String content, boolean personal) {
        return this.note(name, asset, content, personal, null);
    }

    public Note note(String name, BaseAsset asset, String content, boolean personal, Map<String, Object> attributes) {
        Note note = new Note(this.instance);
        note.setAsset(asset);
        note.setName(name);
        note.setContent(content);
        note.setPersonal(personal);
        this.addAttributes(note, attributes);
        note.save();
        return note;
    }

    public TestSuite testSuite(String name, String reference) {
        return this.testSuite(name, reference, null);
    }

    public TestSuite testSuite(String name, String reference, Map<String, Object> attributes) {
        TestSuite testSuite = new TestSuite(this.instance);
        testSuite.setName(name);
        testSuite.setReference(reference);
        this.addAttributes(testSuite, attributes);
        testSuite.save();
        return testSuite;
    }

    public Attachment attachment(String name, BaseAsset asset, String filename, InputStream stream) throws AttachmentLengthExceededException, ApplicationUnavailableException {
        return this.attachment(name, asset, filename, stream, null);
    }

    public Attachment attachment(String name, BaseAsset asset, String filename, InputStream stream, Map<String, Object> attributes) throws AttachmentLengthExceededException, ApplicationUnavailableException {
        Attachment attachment = new Attachment(this.instance);
        attachment.setAsset(asset);
        attachment.setName(name);
        attachment.setFilename(filename);
        attachment.setContentType(MimeType.resolve((String)filename));
        this.addAttributes(attachment, attributes);
        attachment.save();
        if (stream != null) {
            attachment.readFrom(stream);
        }
        return attachment;
    }

    public Retrospective retrospective(String name, Project project) {
        return this.retrospective(name, project, null);
    }

    public Retrospective retrospective(String name, Project project, Map<String, Object> attributes) {
        Retrospective retro = new Retrospective(this.instance);
        retro.setProject(project);
        retro.setName(name);
        this.addAttributes(retro, attributes);
        retro.save();
        return retro;
    }

    public Iteration iteration(Project project) {
        return this.iteration(project, null);
    }

    public Iteration iteration(Project project, Map<String, Object> attributes) {
        Iteration iteration = this.instance.createNew(Iteration.class, project);
        this.addAttributes(iteration, attributes);
        iteration.save();
        iteration.makeFuture();
        return iteration;
    }

    public Iteration iteration(String name, Schedule schedule, DB.DateTime beginDate, DB.DateTime endDate) {
        return this.iteration(name, schedule, beginDate, endDate, null);
    }

    public Iteration iteration(String name, Schedule schedule, DB.DateTime beginDate, DB.DateTime endDate, Map<String, Object> attributes) {
        Iteration iteration = new Iteration(this.instance);
        iteration.setName(name);
        iteration.setSchedule(schedule);
        iteration.setBeginDate(beginDate);
        iteration.setEndDate(endDate);
        this.addAttributes(iteration, attributes);
        iteration.save();
        return iteration;
    }

    public Effort effort(double value, Workitem item, Member member, DB.DateTime date) throws IllegalStateException {
        return this.effort(value, item, member, date, null);
    }

    public Effort effort(double value, Workitem item, Member member, DB.DateTime date, Map<String, Object> attributes) throws IllegalStateException {
        if (!this.instance.getConfiguration().effortTrackingEnabled) {
            throw new IllegalStateException("Effort Tracking is disabled.");
        }
        this.instance.preventTrackingLevelAbuse(item);
        Effort actual = this.instance.createNew(Effort.class, item);
        actual.setValue(value);
        if (member != null) {
            actual.setMember(member);
        }
        if (date != null) {
            actual.setDate(date);
        }
        this.addAttributes(actual, attributes);
        actual.save();
        return actual;
    }

    public Effort effort(double value, Workitem item) throws IllegalStateException {
        return this.effort(value, item, null, null);
    }

    public Effort effort(double value, Workitem item, Map<String, Object> attributes) throws IllegalStateException {
        return this.effort(value, item, null, null, attributes);
    }

    public BuildProject buildProject(String name, String reference) {
        return this.buildProject(name, reference, null);
    }

    public BuildProject buildProject(String name, String reference, Map<String, Object> attributes) {
        BuildProject buildProject = new BuildProject(this.instance);
        buildProject.setName(name);
        buildProject.setReference(reference);
        this.addAttributes(buildProject, attributes);
        buildProject.save();
        return buildProject;
    }

    public BuildRun buildRun(BuildProject buildProject, String name, DB.DateTime date) {
        return this.buildRun(buildProject, name, date, null);
    }

    public BuildRun buildRun(BuildProject buildProject, String name, DB.DateTime date, Map<String, Object> attributes) {
        BuildRun buildRun = new BuildRun(this.instance);
        buildRun.setName(name);
        buildRun.setBuildProject(buildProject);
        buildRun.setDate(date);
        this.addAttributes(buildRun, attributes);
        buildRun.save();
        return buildRun;
    }

    public ChangeSet changeSet(String name, String reference) {
        return this.changeSet(name, reference, null);
    }

    public ChangeSet changeSet(String name, String reference, Map<String, Object> attributes) {
        ChangeSet changeSet = new ChangeSet(this.instance);
        changeSet.setName(name);
        changeSet.setReference(reference);
        this.addAttributes(changeSet, attributes);
        changeSet.save();
        return changeSet;
    }

    public Schedule schedule(String name, Duration iterationLength, Duration iterationGap) {
        return this.schedule(name, iterationLength, iterationGap, null);
    }

    public Schedule schedule(String name, Duration iterationLength, Duration iterationGap, Map<String, Object> attributes) {
        Schedule schedule = new Schedule(this.instance);
        schedule.setName(name);
        schedule.setIterationLength(iterationLength);
        schedule.setIterationGap(iterationGap);
        this.addAttributes(schedule, attributes);
        schedule.save();
        return schedule;
    }

    public Note note(Note responseTo, String name, String content, boolean personal) {
        return this.note(responseTo, name, content, personal, null);
    }

    public Note note(Note responseTo, String name, String content, boolean personal, Map<String, Object> attributes) {
        Note note = new Note(responseTo, this.instance);
        note.setName(name);
        note.setContent(content);
        note.setPersonal(personal);
        this.addAttributes(note, attributes);
        note.save();
        return note;
    }

    public Message message(String subject, String messageBody) {
        ArrayList<Member> recipients = new ArrayList<Member>();
        return this.message(subject, messageBody, recipients);
    }

    public Message message(String subject, String messageBody, Map<String, Object> attributes) {
        ArrayList<Member> recipients = new ArrayList<Member>();
        return this.message(subject, messageBody, recipients, attributes);
    }

    public Message message(String subject, String messageBody, Member recipient) {
        ArrayList<Member> recipients = new ArrayList<Member>();
        recipients.add(recipient);
        return this.message(subject, messageBody, recipients);
    }

    public Message message(String subject, String messageBody, Member recipient, Map<String, Object> attributes) {
        ArrayList<Member> recipients = new ArrayList<Member>();
        recipients.add(recipient);
        return this.message(subject, messageBody, recipients, attributes);
    }

    public Message message(String subject, String messageBody, Collection<Member> recipients) {
        return this.message(subject, messageBody, recipients, null);
    }

    public Message message(String subject, String messageBody, Collection<Member> recipients, Map<String, Object> attributes) {
        Message message = new Message(this.instance);
        message.setName(subject);
        message.setDescription(messageBody);
        if (recipients != null) {
            for (Member recipient : recipients) {
                message.getRecipients().add(recipient);
            }
        }
        this.addAttributes(message, attributes);
        message.save();
        return message;
    }

    public RegressionSuite regressionSuite(String name, RegressionPlan regressionPlan) {
        return this.regressionSuite(name, regressionPlan, null);
    }

    public RegressionSuite regressionSuite(String name, RegressionPlan regressionPlan, Map<String, Object> attributes) {
        RegressionSuite regressionSuite = new RegressionSuite(this.instance);
        regressionSuite.setName(name);
        regressionSuite.setRegressionPlan(regressionPlan);
        this.addAttributes(regressionSuite, attributes);
        regressionSuite.save();
        return regressionSuite;
    }

    public RegressionPlan regressionPlan(String name, Project project) {
        return this.regressionPlan(name, project, null);
    }

    public RegressionPlan regressionPlan(String name, Project project, Map<String, Object> attributes) {
        RegressionPlan regressionPlan = new RegressionPlan(this.instance);
        regressionPlan.setName(name);
        regressionPlan.setProject(project);
        this.addAttributes(regressionPlan, attributes);
        regressionPlan.save();
        return regressionPlan;
    }

    public TestSet testSet(String name, RegressionSuite suite, Project project) {
        return this.testSet(name, suite, project, null);
    }

    public TestSet testSet(String name, RegressionSuite suite, Project project, Map<String, Object> attributes) {
        if (!suite.getRegressionPlan().getProject().equals(project)) {
            throw new UnsupportedOperationException("Suite should belong to the project passed in parameters");
        }
        TestSet testSet = new TestSet(this.instance);
        testSet.setName(name);
        testSet.setRegressionSuite(suite);
        testSet.setProject(project);
        this.addAttributes(testSet, attributes);
        testSet.save();
        return testSet;
    }

    public Environment environment(String name, Project project) {
        return this.environment(name, project, null);
    }

    public Environment environment(String name, Project project, Map<String, Object> attributes) {
        Environment environment = new Environment(this.instance);
        environment.setName(name);
        environment.setProject(project);
        this.addAttributes(environment, attributes);
        environment.save();
        return environment;
    }

    public RegressionTest regressionTest(String name, Project project) {
        return this.regressionTest(name, project, null);
    }

    public RegressionTest regressionTest(String name, Project project, Map<String, Object> attributes) {
        RegressionTest regressionTest = new RegressionTest(this.instance);
        regressionTest.setName(name);
        regressionTest.setProject(project);
        this.addAttributes(regressionTest, attributes);
        regressionTest.save();
        return regressionTest;
    }

    public RegressionTest regressionTest(Test test) {
        RegressionTest regressionTest = new RegressionTest(this.instance);
        regressionTest.setDescription(test.getDescription());
        regressionTest.setGeneratedFrom(test);
        regressionTest.setName(test.getName());
        regressionTest.setProject(test.getProject());
        regressionTest.getType().setCurrentValue(test.getType().getCurrentValue());
        for (Member member : test.getOwners()) {
            regressionTest.getOwners().add(member);
        }
        regressionTest.save();
        return regressionTest;
    }

    public Conversation conversation(String content) {
        return this.conversation(this.instance.getLoggedInMember(), content, null);
    }

    public Conversation conversation(Member author, String content) {
        return this.conversation(author, content, null);
    }

    public Conversation conversation(Member author, String content, Map<String, Object> attributes) {
        Conversation conversation = new Conversation(this.instance);
        conversation.save();
        Expression expression = new Expression(this.instance);
        DB.DateTime utcNow = new DB.DateTime(DB.DateTime.convertLocalToUtc(new Date()));
        expression.setAuthor(author);
        expression.setAuthoredAt(utcNow);
        expression.setContent(content);
        expression.setBelongsTo(conversation);
        this.addAttributes(expression, attributes);
        expression.save();
        return conversation;
    }

    protected void addAttributes(Entity entity, Map<String, Object> attributes) {
        if (attributes != null) {
            for (Map.Entry<String, Object> pairs : attributes.entrySet()) {
                entity.set(pairs.getKey(), pairs.getValue());
            }
        }
    }

    public Expression expression(Member author, String content, Expression inReplyTo) {
        Expression expression = new Expression(this.instance);
        expression.setAuthor(author);
        expression.setContent(content);
        expression.setInReplyTo(inReplyTo);
        expression.save();
        return expression;
    }
}

