/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.apiclient.AndFilterTerm;
import com.versionone.apiclient.Asset;
import com.versionone.apiclient.AssetState;
import com.versionone.apiclient.FilterTerm;
import com.versionone.apiclient.IAssetType;
import com.versionone.apiclient.IAttributeDefinition;
import com.versionone.apiclient.IFilterTerm;
import com.versionone.apiclient.OrderBy;
import com.versionone.apiclient.Query;
import com.versionone.apiclient.QueryResult;
import com.versionone.apiclient.V1Exception;
import com.versionone.om.AssetID;
import com.versionone.om.Attachment;
import com.versionone.om.BaseAsset;
import com.versionone.om.BuildProject;
import com.versionone.om.BuildRun;
import com.versionone.om.ChangeSet;
import com.versionone.om.Conversation;
import com.versionone.om.Defect;
import com.versionone.om.DefectTemplate;
import com.versionone.om.Effort;
import com.versionone.om.Entity;
import com.versionone.om.Environment;
import com.versionone.om.Epic;
import com.versionone.om.Expression;
import com.versionone.om.Goal;
import com.versionone.om.Issue;
import com.versionone.om.Iteration;
import com.versionone.om.Link;
import com.versionone.om.Member;
import com.versionone.om.Message;
import com.versionone.om.MessageReceipt;
import com.versionone.om.Note;
import com.versionone.om.PrimaryWorkitem;
import com.versionone.om.Project;
import com.versionone.om.ProjectAsset;
import com.versionone.om.RegressionPlan;
import com.versionone.om.RegressionSuite;
import com.versionone.om.RegressionTest;
import com.versionone.om.Request;
import com.versionone.om.Retrospective;
import com.versionone.om.SDKException;
import com.versionone.om.Schedule;
import com.versionone.om.SecondaryWorkitem;
import com.versionone.om.Story;
import com.versionone.om.StoryTemplate;
import com.versionone.om.Task;
import com.versionone.om.Team;
import com.versionone.om.TeamFilter;
import com.versionone.om.Test;
import com.versionone.om.TestSet;
import com.versionone.om.TestSuite;
import com.versionone.om.Theme;
import com.versionone.om.V1Instance;
import com.versionone.om.Workitem;
import com.versionone.om.filters.AttachmentFilter;
import com.versionone.om.filters.BaseAssetFilter;
import com.versionone.om.filters.BuildProjectFilter;
import com.versionone.om.filters.BuildRunFilter;
import com.versionone.om.filters.ChangeSetFilter;
import com.versionone.om.filters.DefectFilter;
import com.versionone.om.filters.EffortFilter;
import com.versionone.om.filters.EntityFilter;
import com.versionone.om.filters.EnvironmentFilter;
import com.versionone.om.filters.EpicFilter;
import com.versionone.om.filters.ExpressionFilter;
import com.versionone.om.filters.GoalFilter;
import com.versionone.om.filters.IssueFilter;
import com.versionone.om.filters.IterationFilter;
import com.versionone.om.filters.LinkFilter;
import com.versionone.om.filters.MemberFilter;
import com.versionone.om.filters.MessageFilter;
import com.versionone.om.filters.MessageReceiptFilter;
import com.versionone.om.filters.NoteFilter;
import com.versionone.om.filters.PrimaryWorkitemFilter;
import com.versionone.om.filters.ProjectFilter;
import com.versionone.om.filters.RegressionPlanFilter;
import com.versionone.om.filters.RegressionSuiteFilter;
import com.versionone.om.filters.RegressionTestFilter;
import com.versionone.om.filters.RequestFilter;
import com.versionone.om.filters.RetrospectiveFilter;
import com.versionone.om.filters.ScheduleFilter;
import com.versionone.om.filters.SecondaryWorkitemFilter;
import com.versionone.om.filters.StoryFilter;
import com.versionone.om.filters.TaskFilter;
import com.versionone.om.filters.TestFilter;
import com.versionone.om.filters.TestSetFilter;
import com.versionone.om.filters.ThemeFilter;
import com.versionone.om.filters.TrackedEpicFilter;
import com.versionone.om.filters.WorkitemFilter;
import com.versionone.om.listvalue.ListValue;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V1InstanceGetter {
    private final V1Instance instance;

    V1InstanceGetter(V1Instance instance) {
        this.instance = instance;
    }

    private <T extends Entity> IAssetType resolveAssetType(Class<T> type) {
        return this.instance.getMetaModel().getAssetType(V1Instance.getAssetTypeToken(type));
    }

    <T extends Entity> Collection<T> get(Class<T> clazz, EntityFilter filter) {
        Class<Object> targetEntityType = filter == null ? clazz : filter.getEntityType();
        IAssetType type = this.resolveAssetType(targetEntityType);
        Query query = new Query(type);
        if (filter != null) {
            String defaultToken = V1Instance.getDefaultOrderByToken(targetEntityType);
            IAttributeDefinition defaultOrderBy = null;
            if (!defaultToken.equals("")) {
                defaultOrderBy = this.instance.getMetaModel().getAttributeDefinition(defaultToken);
            }
            query.setFilter(filter.buildFilter(type, this.instance));
            query.setFind(filter.buildFind(type));
            query.setOrderBy(filter.buildOrderBy(type, defaultOrderBy));
        }
        return this.instance.queryToEntityEnum(clazz, query);
    }

    public Collection<Attachment> attachments(AttachmentFilter filter) {
        return this.get(Attachment.class, filter != null ? filter : new AttachmentFilter());
    }

    public Collection<Note> notes(NoteFilter filter) {
        return this.get(Note.class, filter != null ? filter : new NoteFilter());
    }

    public Collection<Link> links(LinkFilter filter) {
        return this.get(Link.class, filter != null ? filter : new LinkFilter());
    }

    public Collection<Effort> effortRecords(EffortFilter filter) {
        return this.get(Effort.class, filter != null ? filter : new EffortFilter());
    }

    public Collection<BaseAsset> baseAssets(BaseAssetFilter filter) {
        return this.get(BaseAsset.class, filter != null ? filter : new BaseAssetFilter());
    }

    public Collection<Story> story(StoryFilter filter) {
        return this.get(Story.class, filter != null ? filter : new StoryFilter());
    }

    public Collection<Epic> epics(EpicFilter filter) {
        return this.get(Epic.class, filter != null ? filter : new EpicFilter());
    }

    public Collection<Epic> trackedEpics(Collection<Project> projects) {
        return this.get(Epic.class, new TrackedEpicFilter(projects));
    }

    public Collection<Defect> defects(DefectFilter filter) {
        return this.get(Defect.class, filter != null ? filter : new DefectFilter());
    }

    public Collection<PrimaryWorkitem> primaryWorkitems(PrimaryWorkitemFilter filter) {
        return this.get(PrimaryWorkitem.class, filter != null ? filter : new PrimaryWorkitemFilter());
    }

    public Collection<Workitem> workitems(WorkitemFilter filter) {
        return this.get(Workitem.class, filter != null ? filter : new WorkitemFilter());
    }

    public Collection<SecondaryWorkitem> secondaryWorkitems(SecondaryWorkitemFilter filter) {
        return this.get(SecondaryWorkitem.class, filter != null ? filter : new SecondaryWorkitemFilter());
    }

    public Collection<Task> tasks(TaskFilter filter) {
        return this.get(Task.class, filter != null ? filter : new TaskFilter());
    }

    public Collection<Test> tests(TestFilter filter) {
        return this.get(Test.class, filter != null ? filter : new TestFilter());
    }

    public Collection<Iteration> iterations(IterationFilter filter) {
        return this.get(Iteration.class, filter != null ? filter : new IterationFilter());
    }

    public Collection<Project> projects(ProjectFilter filter) {
        return this.get(Project.class, filter != null ? filter : new ProjectFilter());
    }

    public Collection<Team> teams(TeamFilter filter) {
        return this.get(Team.class, filter != null ? filter : new TeamFilter());
    }

    public Collection<Theme> themes(ThemeFilter filter) {
        return this.get(Theme.class, filter != null ? filter : new ThemeFilter());
    }

    public Collection<Member> members(MemberFilter filter) {
        return this.get(Member.class, filter != null ? filter : new MemberFilter());
    }

    public Collection<Request> requests(RequestFilter filter) {
        return this.get(Request.class, filter != null ? filter : new RequestFilter());
    }

    public Collection<Goal> goals(GoalFilter filter) {
        return this.get(Goal.class, filter != null ? filter : new GoalFilter());
    }

    public Collection<Issue> issues(IssueFilter filter) {
        return this.get(Issue.class, filter != null ? filter : new IssueFilter());
    }

    public Collection<Retrospective> retrospectives(RetrospectiveFilter filter) {
        return this.get(Retrospective.class, filter != null ? filter : new RetrospectiveFilter());
    }

    public Collection<BuildRun> buildRuns(BuildRunFilter filter) {
        return this.get(BuildRun.class, filter != null ? filter : new BuildRunFilter());
    }

    public Collection<BuildProject> buildProjects(BuildProjectFilter filter) {
        return this.get(BuildProject.class, filter != null ? filter : new BuildProjectFilter());
    }

    public Collection<ChangeSet> changeSets(ChangeSetFilter filter) {
        return this.get(ChangeSet.class, filter != null ? filter : new ChangeSetFilter());
    }

    public Collection<Schedule> schedules(ScheduleFilter filter) {
        return this.get(Schedule.class, filter != null ? filter : new ScheduleFilter());
    }

    public Collection<Message> messages(MessageFilter filter) {
        return this.get(Message.class, filter != null ? filter : new MessageFilter());
    }

    public Collection<Expression> expressions(ExpressionFilter filter) {
        return this.get(Expression.class, filter != null ? filter : new ExpressionFilter());
    }

    Collection<MessageReceipt> messageReceipts(MessageReceiptFilter filter) {
        return this.get(MessageReceipt.class, filter != null ? filter : new MessageReceiptFilter());
    }

    public Collection<RegressionPlan> regressionPlans(RegressionPlanFilter filter) {
        return this.get(RegressionPlan.class, filter != null ? filter : new RegressionPlanFilter());
    }

    public Collection<RegressionSuite> regressionSuites(RegressionSuiteFilter filter) {
        return this.get(RegressionSuite.class, filter != null ? filter : new RegressionSuiteFilter());
    }

    public Collection<TestSet> testSets(TestSetFilter filter) {
        return this.get(TestSet.class, filter != null ? filter : new TestSetFilter());
    }

    public Collection<Environment> environments(EnvironmentFilter filter) {
        return this.get(Environment.class, filter != null ? filter : new EnvironmentFilter());
    }

    public Collection<RegressionTest> regressionTests(RegressionTestFilter filter) {
        return this.get(RegressionTest.class, filter != null ? filter : new RegressionTestFilter());
    }

    public Project projectByID(AssetID id) {
        return this.byID(Project.class, id);
    }

    public Project projectByID(String sId) {
        return this.projectByID(AssetID.valueOf(sId));
    }

    public Iteration iterationByID(AssetID id) {
        return this.byID(Iteration.class, id);
    }

    public Iteration iterationByID(String sId) {
        return this.iterationByID(AssetID.valueOf(sId));
    }

    public Retrospective retrospectiveByID(AssetID id) {
        return this.byID(Retrospective.class, id);
    }

    public Retrospective retrospectiveByID(String sId) {
        return this.retrospectiveByID(AssetID.valueOf(sId));
    }

    public Member memberByID(AssetID id) {
        return this.byID(Member.class, id);
    }

    public Member memberByID(String sId) {
        return this.memberByID(AssetID.valueOf(sId));
    }

    public Team teamByID(AssetID id) {
        return this.byID(Team.class, id);
    }

    public Team teamByID(String sId) {
        return this.teamByID(AssetID.valueOf(sId));
    }

    public Story storyByID(AssetID id) {
        return this.byID(Story.class, id);
    }

    public Story storyByID(String sId) {
        return this.storyByID(AssetID.valueOf(sId));
    }

    public Defect defectByID(AssetID id) {
        return this.byID(Defect.class, id);
    }

    public Defect defectByID(String sId) {
        return this.defectByID(AssetID.valueOf(sId));
    }

    public Issue issueByID(AssetID id) {
        return this.byID(Issue.class, id);
    }

    public Request requestByID(AssetID id) {
        return this.byID(Request.class, id);
    }

    public Theme themeByID(AssetID id) {
        return this.byID(Theme.class, id);
    }

    public Theme themeByID(String sId) {
        return this.themeByID(AssetID.valueOf(sId));
    }

    public Goal goalByID(AssetID id) {
        return this.byID(Goal.class, id);
    }

    public Goal goalByID(String sId) {
        return this.goalByID(AssetID.valueOf(sId));
    }

    public Epic epicByID(AssetID id) {
        return this.byID(Epic.class, id);
    }

    public Epic epicByID(String sId) {
        return this.epicByID(AssetID.valueOf(sId));
    }

    public StoryTemplate storyTemplateByID(AssetID id) {
        return this.byID(StoryTemplate.class, id);
    }

    public StoryTemplate storyTemplateByID(String sId) {
        return this.storyTemplateByID(AssetID.valueOf(sId));
    }

    public DefectTemplate defectTemplateByID(AssetID id) {
        return this.byID(DefectTemplate.class, id);
    }

    public DefectTemplate defectTemplateByID(String sId) {
        return this.defectTemplateByID(AssetID.valueOf(sId));
    }

    public Note noteByID(AssetID id) {
        return this.byID(Note.class, id);
    }

    public Note noteByID(String sId) {
        return this.noteByID(AssetID.valueOf(sId));
    }

    public Link linkByID(AssetID id) {
        return this.byID(Link.class, id);
    }

    public Link linkByID(String sId) {
        return this.linkByID(AssetID.valueOf(sId));
    }

    public Attachment attachmentByID(AssetID id) {
        return this.byID(Attachment.class, id);
    }

    public Attachment attachmentByID(String sId) {
        return this.attachmentByID(AssetID.valueOf(sId));
    }

    public TestSuite testSuiteByID(AssetID id) {
        return this.byID(TestSuite.class, id);
    }

    public TestSuite testSuiteByID(String sId) {
        return this.testSuiteByID(AssetID.valueOf(sId));
    }

    public Effort effortByID(AssetID id) {
        return this.byID(Effort.class, id);
    }

    public Effort effortByID(String assetId) {
        return this.effortByID(AssetID.valueOf(assetId));
    }

    public PrimaryWorkitem primaryWorkitemByID(AssetID id) {
        return this.byID(PrimaryWorkitem.class, id);
    }

    public PrimaryWorkitem primaryWorkitemByID(String sId) {
        return this.primaryWorkitemByID(AssetID.valueOf(sId));
    }

    public SecondaryWorkitem secondaryWorkitemByID(AssetID id) {
        return this.byID(SecondaryWorkitem.class, id);
    }

    public SecondaryWorkitem secondaryWorkitemByID(String sId) {
        return this.secondaryWorkitemByID(AssetID.valueOf(sId));
    }

    public Workitem workitemByID(AssetID id) {
        return this.byID(Workitem.class, id);
    }

    public Workitem workitemByID(String sId) {
        return this.workitemByID(AssetID.valueOf(sId));
    }

    public BaseAsset baseAssetByID(AssetID id) {
        return this.byID(BaseAsset.class, id);
    }

    public BaseAsset baseAssetByID(String sId) {
        return this.baseAssetByID(AssetID.valueOf(sId));
    }

    public BuildRun buildRunByID(AssetID id) {
        return this.byID(BuildRun.class, id);
    }

    public BuildRun buildRunByID(String sId) {
        return this.buildRunByID(AssetID.valueOf(sId));
    }

    public BuildProject buildProjectByID(AssetID id) {
        return this.byID(BuildProject.class, id);
    }

    public BuildProject buildProjectByID(String sId) {
        return this.buildProjectByID(AssetID.valueOf(sId));
    }

    public ChangeSet changeSetByID(AssetID id) {
        return this.byID(ChangeSet.class, id);
    }

    public ChangeSet changeSetByID(String sId) {
        return this.changeSetByID(AssetID.valueOf(sId));
    }

    public Conversation conversationByID(AssetID id) {
        return this.byID(Conversation.class, id);
    }

    public Expression expressionByID(AssetID id) {
        return this.byID(Expression.class, id);
    }

    public <T extends Entity> T byID(Class<T> clazz, AssetID id) {
        return this.instance.getWrapperManager().create(clazz, id, true);
    }

    public <T extends ProjectAsset> T byDisplayID(Class<T> clazz, String displayID) throws SDKException {
        QueryResult result;
        String assetTypeToken = V1Instance.getAssetTypeToken(clazz);
        IAssetType projectAssetType = this.instance.getMetaModel().getAssetType(assetTypeToken);
        IAttributeDefinition idDef = projectAssetType.getAttributeDefinition("Number");
        Query query = new Query(projectAssetType);
        FilterTerm idTerm = new FilterTerm(idDef);
        idTerm.equal(new Object[]{displayID});
        query.setFilter((IFilterTerm)idTerm);
        try {
            result = this.instance.getServices().retrieve(query);
        }
        catch (V1Exception e) {
            throw new SDKException(e);
        }
        if (result.getAssets().length == 0) {
            return null;
        }
        Asset asset = result.getAssets()[0];
        return (T)((ProjectAsset)this.instance.getWrapperManager().create(clazz, AssetID.valueOf(asset.getOid().getToken()), false));
    }

    public Story storyByDisplayID(String displayID) {
        return this.byDisplayID(Story.class, displayID);
    }

    public Defect defectByDisplayID(String displayID) {
        return this.byDisplayID(Defect.class, displayID);
    }

    public Issue issueByDisplayID(String displayID) {
        return this.byDisplayID(Issue.class, displayID);
    }

    public Request requestByDisplayID(String displayID) {
        return this.byDisplayID(Request.class, displayID);
    }

    public Theme themeByDisplayID(String displayID) {
        return this.byDisplayID(Theme.class, displayID);
    }

    public Goal goalByDisplayID(String displayID) {
        return this.byDisplayID(Goal.class, displayID);
    }

    public Epic epicByDisplayID(String displayID) {
        return this.byDisplayID(Epic.class, displayID);
    }

    public PrimaryWorkitem primaryWorkitemByDisplayID(String displayID) {
        return this.byDisplayID(PrimaryWorkitem.class, displayID);
    }

    public SecondaryWorkitem secondaryWorkitemByDisplayID(String displayID) {
        return this.byDisplayID(SecondaryWorkitem.class, displayID);
    }

    public Workitem workitemByDisplayID(String displayID) {
        return this.byDisplayID(Workitem.class, displayID);
    }

    public RegressionPlan regressionPlanByID(AssetID id) {
        return this.byID(RegressionPlan.class, id);
    }

    public RegressionPlan regressionPlanByDisplayID(String displayID) {
        return this.byDisplayID(RegressionPlan.class, displayID);
    }

    public RegressionSuite regressionSuiteByID(AssetID id) {
        return this.byID(RegressionSuite.class, id);
    }

    public TestSet testSetByID(AssetID id) {
        return this.byID(TestSet.class, id);
    }

    public TestSet testSetByDisplayID(String displayID) {
        return this.byDisplayID(TestSet.class, displayID);
    }

    public Environment environmentByID(AssetID id) {
        return this.byID(Environment.class, id);
    }

    public RegressionTest regressionTestByID(AssetID id) {
        return this.byID(RegressionTest.class, id);
    }

    public Project projectByName(String name) throws SDKException {
        QueryResult result;
        IAssetType projectAssetType = this.instance.getMetaModel().getAssetType("Scope");
        IAttributeDefinition nameDef = projectAssetType.getAttributeDefinition("Name");
        Query query = new Query(projectAssetType);
        FilterTerm nameTerm = new FilterTerm(nameDef);
        nameTerm.equal(new Object[]{name});
        query.setFilter((IFilterTerm)nameTerm);
        query.getOrderBy().majorSort(nameDef, OrderBy.Order.Ascending);
        try {
            result = this.instance.getServices().retrieve(query);
        }
        catch (V1Exception e) {
            throw new SDKException(e);
        }
        if (result.getAssets().length == 0) {
            return null;
        }
        Asset asset = result.getAssets()[0];
        return new Project(new AssetID(asset.getOid().getToken()), this.instance);
    }

    public Member memberByUserName(String userName) throws SDKException {
        QueryResult result;
        IAssetType memberAssetType = this.instance.getMetaModel().getAssetType("Member");
        IAttributeDefinition nameDef = memberAssetType.getAttributeDefinition("Username");
        Query query = new Query(memberAssetType);
        FilterTerm usernameTerm = new FilterTerm(nameDef);
        usernameTerm.equal(new Object[]{userName});
        query.setFilter((IFilterTerm)usernameTerm);
        query.getOrderBy().majorSort(nameDef, OrderBy.Order.Ascending);
        try {
            result = this.instance.getServices().retrieve(query);
        }
        catch (V1Exception e) {
            throw new SDKException(e);
        }
        if (result.getAssets().length == 0) {
            return null;
        }
        Asset asset = result.getAssets()[0];
        return new Member(new AssetID(asset.getOid().getToken()), this.instance);
    }

    public <T extends ListValue> Collection<T> listTypeValues(Class<T> valuesClass) {
        IAssetType typeToGet = this.instance.getMetaModel().getAssetType(V1Instance.getAssetTypeToken(valuesClass));
        Query query = new Query(typeToGet);
        FilterTerm assetStateTerm = new FilterTerm(typeToGet.getAttributeDefinition("AssetState"));
        assetStateTerm.notEqual(new Object[]{AssetState.Closed});
        query.setFilter((IFilterTerm)new AndFilterTerm(new IFilterTerm[]{assetStateTerm}));
        return this.instance.queryToEntityEnum(valuesClass, query);
    }

    public Schedule scheduleByID(AssetID id) {
        return this.byID(Schedule.class, id);
    }

    public Schedule scheduleByName(String name) {
        QueryResult result;
        IAssetType scheduleAssetType = this.instance.getMetaModel().getAssetType("Schedule");
        IAttributeDefinition nameDef = scheduleAssetType.getAttributeDefinition("Name");
        Query query = new Query(scheduleAssetType);
        FilterTerm nameTerm = new FilterTerm(nameDef);
        nameTerm.equal(new Object[]{name});
        query.setFilter((IFilterTerm)nameTerm);
        query.getOrderBy().majorSort(nameDef, OrderBy.Order.Ascending);
        try {
            result = this.instance.getServices().retrieve(query);
        }
        catch (Exception e) {
            throw new SDKException(e);
        }
        if (result.getAssets().length == 0) {
            return null;
        }
        Asset asset = result.getAssets()[0];
        return new Schedule(new AssetID(asset.getOid().getToken()), this.instance);
    }
}

