/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om;

import com.versionone.Oid;
import com.versionone.apiclient.APIException;
import com.versionone.apiclient.Asset;
import com.versionone.apiclient.Attribute;
import com.versionone.apiclient.IAssetType;
import com.versionone.apiclient.IAttributeDefinition;
import com.versionone.apiclient.IMetaModel;
import com.versionone.apiclient.MetaException;
import com.versionone.apiclient.OidException;
import com.versionone.apiclient.Query;
import com.versionone.apiclient.V1Exception;
import com.versionone.om.AssetID;
import com.versionone.om.Entity;
import com.versionone.om.MetaDataAttribute;
import com.versionone.om.SDKException;
import com.versionone.om.V1Instance;
import com.versionone.om.listvalue.CustomListValue;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperManager {
    private static final String ENTITIES_FILE = "entities.properties";
    private final V1Instance instance;
    private final Object typeMapLock = new Object();
    private Map<String, List<Class<Entity>>> typeMap;
    private final Map<IMetaModel, List<IAssetType>> withoutAssetStates = new HashMap<IMetaModel, List<IAssetType>>();

    public WrapperManager(V1Instance instance) {
        this.instance = instance;
    }

    public <T extends Entity> T create(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(V1Instance.class);
            return (T)((Entity)constructor.newInstance(this.instance));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create Entity:" + clazz.getSimpleName());
        }
    }

    public <T extends Entity> T create(Class<T> clazz, AssetID id, boolean validate) {
        try {
            Class<T> targetClass = clazz == CustomListValue.class ? clazz : (validate || clazz == null || Modifier.isAbstract(clazz.getModifiers()) ? this.findType(id, validate) : clazz);
            if (targetClass == null) {
                return null;
            }
            Constructor<T> constructor = targetClass.getDeclaredConstructor(AssetID.class, V1Instance.class);
            return (T)((Entity)constructor.newInstance(id, this.instance));
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<Class<Entity>>> getTypeMap() {
        if (this.typeMap == null) {
            Object object = this.typeMapLock;
            synchronized (object) {
                if (this.typeMap == null) {
                    HashMap<String, List<Class<Entity>>> map = new HashMap<String, List<Class<Entity>>>();
                    WrapperManager.fillMap(map);
                    this.typeMap = map;
                }
            }
        }
        return this.typeMap;
    }

    private static void fillMap(Map<String, List<Class<Entity>>> map) {
        try {
            String[] entitiesNames;
            Properties entProps = new Properties();
            entProps.load(WrapperManager.class.getResourceAsStream(ENTITIES_FILE));
            String entitiesString = entProps.getProperty("entities");
            for (String name : entitiesNames = entitiesString.split(",")) {
                String className = name.trim();
                try {
                    String token;
                    Class<?> entityClass;
                    MetaDataAttribute metaDataAttribute;
                    Class<?> clazz = Class.forName(className);
                    if (!Entity.class.isAssignableFrom(clazz) || (metaDataAttribute = (entityClass = clazz).getAnnotation(MetaDataAttribute.class)) == null || (token = metaDataAttribute.value()).length() <= 0) continue;
                    List<Class<Entity>> list = map.get(token);
                    if (list == null) {
                        list = new LinkedList<Class<Entity>>();
                        map.put(token, list);
                    }
                    list.add(entityClass);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("entities.properties has incorrect record: " + name);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read information from entities.propertiesfile");
        }
        Comparator<Class<Entity>> comporator = new Comparator<Class<Entity>>(){

            @Override
            public int compare(Class<Entity> o1, Class<Entity> o2) {
                return WrapperManager.getAssetStateFilter(o1) - WrapperManager.getAssetStateFilter(o2);
            }
        };
        for (List<Class<Entity>> list : map.values()) {
            Collections.sort(list, Collections.reverseOrder(comporator));
        }
    }

    static short getAssetStateFilter(Class<?> type) {
        MetaDataAttribute mda = type.getAnnotation(MetaDataAttribute.class);
        return mda != null ? (short)mda.assetState() : (short)-1;
    }

    private <T extends Entity> Class<T> findType(AssetID id, boolean validate) throws SDKException {
        Oid oid = this.getOid(id);
        List<Class<Entity>> list = this.getTypeMap().get(oid.getAssetType().getToken());
        if (list != null) {
            boolean attribChecked = false;
            Attribute attrib = null;
            for (Class<Entity> type : list) {
                int state;
                int filterState = WrapperManager.getAssetStateFilter(type);
                if (!(filterState != -1 || validate && list.size() != 1)) {
                    if (!validate) {
                        return type;
                    }
                    Asset asset = this.getAsset(oid);
                    if (null != asset) {
                        this.instance.setAsset(id, asset);
                        return type;
                    }
                    return null;
                }
                if (!attribChecked) {
                    attribChecked = true;
                    attrib = this.resolveAssetState(id, validate);
                }
                if (attrib == null) continue;
                try {
                    state = attrib.getValue() != null ? (Integer)attrib.getValue() : -1;
                }
                catch (APIException e) {
                    throw new SDKException(e);
                }
                if (filterState != -1 && state != filterState) continue;
                return type;
            }
        }
        return null;
    }

    private Attribute resolveAssetState(AssetID id, boolean validate) throws SDKException {
        Attribute attrib;
        Asset asset;
        Oid oid = this.getOid(id);
        IAttributeDefinition assetStateDef = oid.getAssetType().getAttributeDefinition("AssetState");
        Asset asset2 = asset = validate ? null : this.instance.getAsset(id);
        if (asset == null) {
            asset = this.getAsset(oid);
            if (asset == null) {
                return null;
            }
            this.instance.setAsset(id, asset);
        }
        if ((attrib = asset.getAttribute(assetStateDef)) == null) {
            attrib = this.getAsset(oid).getAttribute(assetStateDef);
        }
        return attrib;
    }

    private Oid getOid(AssetID id) throws SDKException {
        try {
            return Oid.fromToken(id.getToken(), this.instance.getApiClient().getMetaModel());
        }
        catch (OidException e) {
            throw new SDKException(e);
        }
    }

    private Asset getAsset(Oid oid) throws SDKException {
        Asset[] assets;
        this.createAssetStatesStorage();
        Query query = new Query(oid);
        IMetaModel model = this.instance.getApiClient().getMetaModel();
        if (!this.withoutAssetStates.get(model).contains(query.getAssetType())) {
            try {
                query.getSelection().add((Object)query.getAssetType().getAttributeDefinition("AssetState"));
            }
            catch (MetaException e) {
                this.withoutAssetStates.get(model).add(query.getAssetType());
            }
        }
        try {
            assets = this.instance.getApiClient().getServices().retrieve(query).getAssets();
        }
        catch (V1Exception e) {
            throw new SDKException(e);
        }
        return assets != null && assets.length > 0 ? assets[0] : null;
    }

    private void createAssetStatesStorage() {
        if (!this.withoutAssetStates.containsKey(this.instance.getApiClient().getMetaModel())) {
            IMetaModel meta = this.instance.getApiClient().getMetaModel();
            try {
                IAssetType assetType = meta.getAssetType("Actual");
                this.withoutAssetStates.put(meta, Arrays.asList(assetType));
            }
            catch (MetaException e) {
                this.withoutAssetStates.put(meta, new ArrayList());
            }
        }
    }
}

