/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om.filters;

import com.versionone.DB;
import com.versionone.apiclient.FilterTerm;
import com.versionone.om.filters.ComparisonSearcher;
import java.util.GregorianCalendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateSearcher
extends ComparisonSearcher<DB.DateTime> {
    @Override
    public void addTerm(FilterTerm.Operator op, DB.DateTime date) throws IllegalStateException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date.getValue());
        cal.set(14, 0);
        switch (op) {
            case GreaterThan: {
                cal.add(13, 1);
                super.addTerm(FilterTerm.Operator.GreaterThanOrEqual, new DB.DateTime(cal.getTime()));
                break;
            }
            case GreaterThanOrEqual: {
                super.addTerm(FilterTerm.Operator.GreaterThanOrEqual, new DB.DateTime(cal.getTime()));
                break;
            }
            case LessThan: {
                super.addTerm(FilterTerm.Operator.LessThan, new DB.DateTime(cal.getTime()));
                break;
            }
            case LessThanOrEqual: {
                cal.add(13, 1);
                super.addTerm(FilterTerm.Operator.LessThan, new DB.DateTime(cal.getTime()));
                break;
            }
            case Equal: {
                super.addTerm(FilterTerm.Operator.GreaterThanOrEqual, new DB.DateTime(cal.getTime()));
                cal.add(13, 1);
                super.addTerm(FilterTerm.Operator.LessThan, new DB.DateTime(cal.getTime()));
                break;
            }
            default: {
                throw new IllegalStateException("This operation is not supported: " + op);
            }
        }
    }
}

