/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om.filters;

import com.versionone.apiclient.AttributeSelection;
import com.versionone.apiclient.IAssetType;
import com.versionone.apiclient.IAttributeDefinition;
import com.versionone.apiclient.IFilterTerm;
import com.versionone.apiclient.OrderBy;
import com.versionone.apiclient.QueryFind;
import com.versionone.om.Entity;
import com.versionone.om.MetaRenamedAttribute;
import com.versionone.om.V1Instance;
import com.versionone.om.filters.DateSearcher;
import com.versionone.om.filters.FilterBuilder;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityFilter {
    private static final boolean USE_ARRAY_LISTS = false;
    private static final int INITIAL_ARRAY_LISTS_SIZE = 10;
    public final List<String> orderBy = EntityFilter.newList();
    public final StringSearcher find = new StringSearcher();
    public final DateSearcher createDateUtc = new DateSearcher();
    public final DateSearcher changeDateUtc = new DateSearcher();

    protected static <T> List<T> newList() {
        return new LinkedList();
    }

    public abstract Class<? extends Entity> getEntityType();

    private String resolvePropertyName(String propertyName) {
        Method[] methods;
        Class<? extends Entity> clazz = this.getEntityType();
        String methodName = EntityFilter.getterName(propertyName);
        for (Method method : methods = clazz.getDeclaredMethods()) {
            MetaRenamedAttribute renamed;
            if (!method.getName().equals(methodName) || (renamed = method.getAnnotation(MetaRenamedAttribute.class)) == null) continue;
            return renamed.value();
        }
        return propertyName;
    }

    private static String getterName(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            return propertyName;
        }
        return "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }

    public IFilterTerm buildFilter(IAssetType assetType, V1Instance instance) {
        FilterBuilder builder = new FilterBuilder(assetType, instance);
        this.internalModifyFilter(builder);
        this.internalModifyState(builder);
        return builder.root.hasTerm() ? builder.root : null;
    }

    void internalModifyFilter(FilterBuilder builder) {
        builder.comparison("CreateDateUTC", this.createDateUtc);
        builder.comparison("ChangeDateUTC", this.changeDateUtc);
    }

    void internalModifyState(FilterBuilder builder) {
    }

    public OrderBy buildOrderBy(IAssetType assetType, IAttributeDefinition defaultOrderBy) {
        OrderBy order = new OrderBy();
        if (this.orderBy.size() > 0) {
            for (String s : this.orderBy) {
                order.minorSort(assetType.getAttributeDefinition(this.resolvePropertyName(s)), OrderBy.Order.Ascending);
            }
        } else if (defaultOrderBy != null) {
            order.minorSort(defaultOrderBy, OrderBy.Order.Ascending);
        }
        return order;
    }

    public QueryFind buildFind(IAssetType assetType) {
        String searchString = this.find.getSearchString();
        if (searchString != null && searchString.trim().length() != 0) {
            AttributeSelection attributes = new AttributeSelection();
            if (this.find.fields.size() > 0) {
                for (String field : this.find.fields) {
                    attributes.add((Object)assetType.getAttributeDefinition(this.resolvePropertyName(field)));
                }
            } else {
                if (assetType.getShortNameAttribute() != null) {
                    attributes.add((Object)assetType.getShortNameAttribute());
                }
                if (assetType.getNameAttribute() != null) {
                    attributes.add((Object)assetType.getNameAttribute());
                }
                if (assetType.getDescriptionAttribute() != null) {
                    attributes.add((Object)assetType.getDescriptionAttribute());
                }
            }
            return new QueryFind(this.find.getSearchString(), attributes);
        }
        return null;
    }

    public static class StringSearcher {
        private String searchString;
        public final Collection<String> fields = EntityFilter.newList();

        public String getSearchString() {
            return this.searchString;
        }

        public void setSearchString(String value) {
            this.searchString = value;
        }
    }
}

