/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om.filters;

import com.versionone.apiclient.IFilterTerm;
import com.versionone.apiclient.TokenTerm;
import com.versionone.om.Entity;
import com.versionone.om.Epic;
import com.versionone.om.Goal;
import com.versionone.om.Issue;
import com.versionone.om.Request;
import com.versionone.om.Theme;
import com.versionone.om.filters.ComparisonSearcher;
import com.versionone.om.filters.FilterBuilder;
import com.versionone.om.filters.WorkitemFilter;
import com.versionone.om.listvalue.EpicPriority;
import com.versionone.om.listvalue.EpicStatus;
import com.versionone.om.listvalue.EpicType;
import com.versionone.om.listvalue.WorkitemSource;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EpicFilter
extends WorkitemFilter {
    public final List<String> status = EpicFilter.newList();
    public final List<String> source = EpicFilter.newList();
    public final List<Theme> theme = EpicFilter.newList();
    public final ComparisonSearcher<Double> risk = new ComparisonSearcher();
    public final ComparisonSearcher<Double> swag = new ComparisonSearcher();
    public final ComparisonSearcher<Double> value = new ComparisonSearcher();
    public final List<String> type = EpicFilter.newList();
    public final List<String> priority = EpicFilter.newList();
    public final List<Epic> parent = EpicFilter.newList();
    public final List<Goal> goals = EpicFilter.newList();
    public final List<Issue> issues = EpicFilter.newList();
    public final List<Issue> blockingIssues = EpicFilter.newList();
    public final List<Request> requests = EpicFilter.newList();

    @Override
    public Class<? extends Entity> getEntityType() {
        return Epic.class;
    }

    @Override
    void internalModifyFilter(FilterBuilder builder) {
        super.internalModifyFilter(builder);
        builder.simple("Reference", this.reference);
        builder.comparison("Risk", this.risk);
        builder.comparison("Swag", this.swag);
        builder.comparison("Value", this.value);
        builder.relation("Parent", this.theme);
        builder.relation("Super", this.parent);
        builder.multiRelation("Goals", this.goals);
        builder.multiRelation("Issues", this.issues);
        builder.multiRelation("BlockingIssues", this.blockingIssues);
        builder.multiRelation("Owners", this.owners);
        builder.multiRelation("Requests", this.requests);
        builder.listRelation("Status", this.status, EpicStatus.class);
        builder.listRelation("Source", this.source, WorkitemSource.class);
        builder.listRelation("Category", this.type, EpicType.class);
        builder.listRelation("Priority", this.priority, EpicPriority.class);
    }

    @Override
    void internalModifyState(FilterBuilder builder) {
        if (this.hasState()) {
            builder.root.and(new IFilterTerm[]{this.isActive() ? new TokenTerm("AssetState='Active';AssetType='Epic'") : new TokenTerm("AssetState='Closed';AssetType='Epic'")});
        } else {
            builder.root.and(new IFilterTerm[]{new TokenTerm("AssetState!='Dead';AssetType='Epic'")});
        }
    }
}

