/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om.filters;

import com.versionone.apiclient.IFilterTerm;
import com.versionone.apiclient.TokenTerm;
import com.versionone.om.BaseAsset;
import com.versionone.om.Conversation;
import com.versionone.om.Entity;
import com.versionone.om.Expression;
import com.versionone.om.Member;
import com.versionone.om.filters.DateSearcher;
import com.versionone.om.filters.EntityFilter;
import com.versionone.om.filters.FilterBuilder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionFilter
extends EntityFilter {
    private final List<State> state = new ArrayList<State>(2);
    public List<Member> author = ExpressionFilter.newList();
    public DateSearcher authoredAt = new DateSearcher();
    public List<Conversation> belongsTo = ExpressionFilter.newList();
    public List<Expression> inReplyTo = ExpressionFilter.newList();
    public List<Expression> replies = ExpressionFilter.newList();
    public List<BaseAsset> mentions = ExpressionFilter.newList();

    @Override
    public Class<? extends Entity> getEntityType() {
        return Expression.class;
    }

    public List<State> getState() {
        return this.state;
    }

    boolean hasState() {
        return this.getState().size() == 1;
    }

    boolean isActive() {
        return this.getState().contains((Object)State.Active);
    }

    boolean isClosed() {
        return this.getState().contains((Object)State.Closed);
    }

    @Override
    void internalModifyFilter(FilterBuilder builder) {
        super.internalModifyFilter(builder);
        builder.relation("Author", this.author);
        builder.comparison("AuthoredAt", this.authoredAt);
        builder.relation("BelongsTo", this.belongsTo);
        builder.relation("InReplyTo", this.inReplyTo);
        builder.multiRelation("Replies", this.replies);
        builder.multiRelation("Mentions", this.mentions);
    }

    @Override
    void internalModifyState(FilterBuilder builder) {
        if (this.hasState()) {
            if (this.isActive()) {
                builder.root.and(new IFilterTerm[]{new TokenTerm("AssetState='Active';AssetType='Expression'")});
            } else {
                builder.root.and(new IFilterTerm[]{new TokenTerm("AssetState='Closed';AssetType='Expression'")});
            }
        } else {
            builder.root.and(new IFilterTerm[]{new TokenTerm("AssetState!='Dead';AssetType='Expression'")});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        Active,
        Closed;

    }
}

