/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om.filters;

import com.versionone.apiclient.IFilterTerm;
import com.versionone.apiclient.TextBuilder;
import com.versionone.apiclient.TokenTerm;
import com.versionone.apiclient.ValueStringizer;
import com.versionone.om.Entity;
import com.versionone.om.Iteration;
import com.versionone.om.Schedule;
import com.versionone.om.filters.BaseAssetFilter;
import com.versionone.om.filters.FilterBuilder;
import com.versionone.util.IDelegate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationFilter
extends BaseAssetFilter {
    public List<IterationState> state = IterationFilter.newList();
    public List<Schedule> schedule = IterationFilter.newList();

    @Override
    public Class<? extends Entity> getEntityType() {
        return Iteration.class;
    }

    @Override
    boolean hasState() {
        return this.state.size() != 0;
    }

    @Override
    boolean isActive() {
        return this.state.contains((Object)IterationState.Active);
    }

    @Override
    boolean isClosed() {
        return this.state.contains((Object)IterationState.Closed);
    }

    boolean hasFuture() {
        return this.state.contains((Object)IterationState.Future);
    }

    @Override
    void internalModifyState(FilterBuilder builder) {
        ArrayList<String> states = new ArrayList<String>(3);
        if (this.hasFuture()) {
            states.add("Future");
        }
        if (this.isActive()) {
            states.add("Active");
        }
        if (this.isClosed()) {
            states.add("Closed");
        }
        if (states.size() > 0 && states.size() < 3) {
            builder.root.and(new IFilterTerm[]{new TokenTerm("AssetState=" + TextBuilder.join(states, (String)",", (IDelegate)TextBuilder.STRINGIZER_DELEGATE.build((Object)new ValueStringizer(), "stringize")))});
        } else {
            builder.root.and(new IFilterTerm[]{new TokenTerm("AssetState!='Dead'")});
        }
    }

    @Override
    void internalModifyFilter(FilterBuilder builder) {
        super.internalModifyFilter(builder);
        builder.relation("Schedule", this.schedule);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IterationState {
        Future,
        Active,
        Closed;

    }
}

