/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om.filters;

import com.versionone.apiclient.IFilterTerm;
import com.versionone.apiclient.TokenTerm;
import com.versionone.om.BaseAsset;
import com.versionone.om.Entity;
import com.versionone.om.Member;
import com.versionone.om.Message;
import com.versionone.om.filters.BaseAssetFilter;
import com.versionone.om.filters.FilterBuilder;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFilter
extends BaseAssetFilter {
    public List<BaseAsset> relatedAsset = MessageFilter.newList();
    private Boolean unread = null;
    private Boolean archived = null;
    public final List<Member> recipient = MessageFilter.newList();
    public List<Member> sender = MessageFilter.newList();

    @Override
    public Class<? extends Entity> getEntityType() {
        return Message.class;
    }

    public void isUnread(boolean value) {
        this.unread = value;
    }

    public boolean isUnread() {
        return this.unread;
    }

    public void isArchived(boolean value) {
        this.archived = value;
    }

    public boolean isArchived() {
        return this.archived;
    }

    @Override
    void internalModifyFilter(FilterBuilder builder) {
        super.internalModifyFilter(builder);
        builder.relation("Asset", this.relatedAsset);
        builder.relation("CreatedBy", this.sender);
        for (Member member : this.recipient) {
            builder.root.and(new IFilterTerm[]{new TokenTerm(String.format("Message.Receipts[Recipient='%s';IsDeleted='false']", member.getID().getToken()))});
        }
        if (null != this.unread) {
            builder.simple("Receipts.IsUnread", this.unread);
        }
        if (null != this.archived) {
            builder.simple("Receipts.IsArchived", this.archived);
        }
    }
}

