/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.om.filters;

import com.versionone.apiclient.APIException;
import com.versionone.apiclient.FilterTerm;
import com.versionone.apiclient.IAssetType;
import com.versionone.apiclient.IAttributeDefinition;
import com.versionone.apiclient.IFilterTerm;
import com.versionone.apiclient.IMetaModel;
import com.versionone.apiclient.TokenTerm;
import com.versionone.om.Entity;
import com.versionone.om.Epic;
import com.versionone.om.Project;
import com.versionone.om.filters.BaseAssetFilter;
import com.versionone.om.filters.FilterBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackedEpicFilter
extends BaseAssetFilter {
    private final List<Project> projects = new ArrayList<Project>();

    @Override
    public Class<? extends Entity> getEntityType() {
        return Epic.class;
    }

    public TrackedEpicFilter(Collection projects) {
        if (projects != null) {
            this.projects.addAll(projects);
        }
    }

    @Override
    void internalModifyFilter(FilterBuilder builder) {
        super.internalModifyFilter(builder);
        try {
            if (this.projects.size() == 1) {
                this.createSingleScopeFilter(builder);
            } else {
                this.createMultipleScopeFilter(builder);
            }
        }
        catch (APIException e) {
            throw new RuntimeException(e);
        }
    }

    private void createMultipleScopeFilter(FilterBuilder builder) throws APIException {
        builder.relation("Scope", this.projects);
        IMetaModel metaModel = builder.instance.getApiClient().getMetaModel();
        IAssetType epicType = metaModel.getAssetType("Epic");
        IAttributeDefinition scopeAttribute = epicType.getAttributeDefinition("Scope");
        FilterTerm scopeTerm = new FilterTerm(scopeAttribute);
        ArrayList<String> projectTokens = new ArrayList<String>();
        for (Project project : this.projects) {
            projectTokens.add(project.toString());
        }
        scopeTerm.operate(FilterTerm.Operator.Equal, projectTokens.toArray());
        IAttributeDefinition superAndUpAttribute = epicType.getAttributeDefinition("SuperAndUp").filter((IFilterTerm)scopeTerm);
        FilterTerm superAndUpTerm = builder.root.Term(superAndUpAttribute);
        superAndUpTerm.notExists();
    }

    private void createSingleScopeFilter(FilterBuilder builder) throws APIException {
        Project project = this.projects.get(0);
        IMetaModel metaModel = builder.instance.getApiClient().getMetaModel();
        IAssetType epicType = metaModel.getAssetType("Epic");
        IAssetType scopeType = metaModel.getAssetType("Scope");
        IAttributeDefinition notClosedScopeAttribute = scopeType.getAttributeDefinition("AssetState");
        FilterTerm notClosedScopeTerm = new FilterTerm(notClosedScopeAttribute);
        notClosedScopeTerm.notEqual(new Object[]{"Closed"});
        IAttributeDefinition scopeAttribute = epicType.getAttributeDefinition("Scope.ParentMeAndUp").filter((IFilterTerm)notClosedScopeTerm);
        FilterTerm scopeTerm = builder.root.Term(scopeAttribute);
        scopeTerm.equal(new Object[]{project.toString()});
        IAttributeDefinition superAndUpAttribute = epicType.getAttributeDefinition("SuperAndUp");
        superAndUpAttribute = superAndUpAttribute.filter((IFilterTerm)scopeTerm);
        FilterTerm superAndUpTerm = builder.root.Term(superAndUpAttribute);
        superAndUpTerm.notExists();
    }

    @Override
    void internalModifyState(FilterBuilder builder) {
        if (this.hasState()) {
            builder.root.and(new IFilterTerm[]{this.isActive() ? new TokenTerm("AssetState='Active';AssetType='Epic'") : new TokenTerm("AssetState='Closed';AssetType='Epic'")});
        } else {
            builder.root.and(new IFilterTerm[]{new TokenTerm("AssetState!='Dead';AssetType='Epic'")});
        }
    }
}

