/*
 * Decompiled with CFR 0.152.
 */
package com.wealoha.thrift;

import com.wealoha.thrift.ServiceInfo;
import com.wealoha.thrift.ThriftClientPool;
import com.wealoha.thrift.exception.NoBackendServiceException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.thrift.TServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardedThriftClientPool<K, T extends TServiceClient> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<ServiceInfo> serviceList;
    private final Function<K, Integer> hashFunction;
    private final Function<List<ServiceInfo>, List<List<ServiceInfo>>> partitionFunction;
    private final Function<List<ServiceInfo>, ThriftClientPool<T>> clientPoolFunction;
    private Map<Integer, ThriftClientPool<T>> poolMap;
    private List<List<ServiceInfo>> servicePartitions;

    public ShardedThriftClientPool(List<ServiceInfo> serviceList, Function<K, Integer> hashFunction, Function<List<ServiceInfo>, List<List<ServiceInfo>>> partitionFunction, Function<List<ServiceInfo>, ThriftClientPool<T>> clientPoolFunction) {
        this.hashFunction = hashFunction;
        this.partitionFunction = partitionFunction;
        this.clientPoolFunction = clientPoolFunction;
        this.init(serviceList);
    }

    public ShardedThriftClientPool(List<ServiceInfo> serviceList, Function<K, Integer> hashFunction, Function<List<ServiceInfo>, ThriftClientPool<T>> clientPoolFunction) {
        this(serviceList, hashFunction, servers -> servers.stream().map(server -> Collections.singletonList(server)).collect(Collectors.toList()), clientPoolFunction);
    }

    private void init(List<ServiceInfo> services) {
        if (services == null || services.size() == 0) {
            throw new IllegalArgumentException("serviceList is empty");
        }
        this.poolMap = new HashMap<Integer, ThriftClientPool<T>>();
        this.serviceList = services;
        this.servicePartitions = this.partitionFunction.apply(this.serviceList);
        if (this.servicePartitions == null || this.servicePartitions.size() == 0) {
            throw new IllegalStateException("partitionFunction should not return empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThriftClientPool<T> getShardedPool(K key) throws NoBackendServiceException {
        int hash = this.hashFunction.apply(key);
        int shard = hash % this.servicePartitions.size();
        this.logger.debug("getPool by key: hash={}, shard={}/{}", new Object[]{hash, shard, this.servicePartitions.size()});
        List<ServiceInfo> servers = this.servicePartitions.get(shard);
        if (servers == null || servers.size() == 0) {
            throw new NoBackendServiceException("no servers mapping for key: " + key);
        }
        ThriftClientPool<T> pool = this.poolMap.get(shard);
        if (pool == null) {
            Map<Integer, ThriftClientPool<T>> map = this.poolMap;
            synchronized (map) {
                pool = this.poolMap.get(shard);
                if (pool == null) {
                    this.logger.debug("init client pool: shard={}, servers={}", (Object)shard, servers);
                    pool = this.clientPoolFunction.apply(servers);
                    this.poolMap.put(shard, pool);
                }
            }
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, ThriftClientPool<T>> setServices(List<ServiceInfo> services) {
        Map<Integer, ThriftClientPool<T>> map = this.poolMap;
        synchronized (map) {
            this.logger.info("reinit pool using new serviceList: {}", services);
            Map<Integer, ThriftClientPool<T>> previousMap = this.poolMap;
            this.init(services);
            return previousMap;
        }
    }
}

