/*
 * Decompiled with CFR 0.152.
 */
package com.wealoha.thrift;

import com.wealoha.thrift.ServiceInfo;
import com.wealoha.thrift.ThriftUtil;
import java.io.Closeable;
import org.apache.commons.pool2.ObjectPool;
import org.apache.thrift.TServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftClient<T extends TServiceClient>
implements Closeable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final T client;
    private final ObjectPool<ThriftClient<T>> pool;
    private final ServiceInfo serviceInfo;
    private boolean finish;

    public ThriftClient(T client, ObjectPool<ThriftClient<T>> pool, ServiceInfo serviceInfo) {
        this.client = client;
        this.pool = pool;
        this.serviceInfo = serviceInfo;
    }

    public ServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    public T iFace() {
        return this.client;
    }

    @Override
    public void close() {
        try {
            if (this.finish) {
                this.logger.info("return object to pool: " + this);
                this.finish = false;
                this.pool.returnObject((Object)this);
            } else {
                this.logger.warn("not return object cause not finish {}", this.client);
                this.closeClient();
                this.pool.invalidateObject((Object)this);
            }
        }
        catch (Exception e) {
            this.logger.warn("return object fail, close", (Throwable)e);
            this.closeClient();
        }
    }

    void closeClient() {
        this.logger.debug("close client {}", (Object)this);
        ThriftUtil.closeClient(this.client);
    }

    public void finish() {
        this.finish = true;
    }

    void setFinish(boolean finish) {
        this.finish = finish;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.closeClient();
    }
}

