/*
 * Decompiled with CFR 0.152.
 */
package com.wealoha.thrift;

import com.wealoha.thrift.PoolConfig;
import com.wealoha.thrift.ServiceInfo;
import com.wealoha.thrift.ThriftClient;
import com.wealoha.thrift.ThriftProtocolFactory;
import com.wealoha.thrift.exception.ConnectionFailException;
import com.wealoha.thrift.exception.NoBackendServiceException;
import com.wealoha.thrift.exception.ThriftException;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftClientPool<T extends TServiceClient> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Function<TTransport, T> clientFactory;
    private final GenericObjectPool<ThriftClient<T>> pool;
    private List<ServiceInfo> services;
    private boolean serviceReset = false;
    private final PoolConfig poolConfig;

    public ThriftClientPool(List<ServiceInfo> services, Function<TTransport, T> factory) {
        this(services, factory, new PoolConfig(), null);
    }

    public ThriftClientPool(List<ServiceInfo> services, Function<TTransport, T> factory, PoolConfig config) {
        this(services, factory, config, null);
    }

    public ThriftClientPool(List<ServiceInfo> services, Function<TTransport, T> factory, PoolConfig config, ThriftProtocolFactory pFactory) {
        if (services == null || services.size() == 0) {
            throw new IllegalArgumentException("services is empty!");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory is empty!");
        }
        if (config == null) {
            throw new IllegalArgumentException("config is empty!");
        }
        this.services = services;
        this.clientFactory = factory;
        this.poolConfig = config;
        this.poolConfig.setTestOnReturn(true);
        this.poolConfig.setTestOnBorrow(true);
        this.pool = new GenericObjectPool((PooledObjectFactory)new BasePooledObjectFactory<ThriftClient<T>>(){

            public ThriftClient<T> create() throws Exception {
                List serviceList = ThriftClientPool.this.services;
                ServiceInfo serviceInfo = ThriftClientPool.this.getRandomService(serviceList);
                TTransport transport = ThriftClientPool.this.getTransport(serviceInfo);
                try {
                    transport.open();
                }
                catch (TTransportException e) {
                    ThriftClientPool.this.logger.info("transport open fail service: host={}, port={}", (Object)serviceInfo.getHost(), (Object)serviceInfo.getPort());
                    if (ThriftClientPool.this.poolConfig.isFailover()) {
                        while (true) {
                            try {
                                serviceList = ThriftClientPool.this.removeFailService(serviceList, serviceInfo);
                                serviceInfo = ThriftClientPool.this.getRandomService(serviceList);
                                transport = ThriftClientPool.this.getTransport(serviceInfo);
                                ThriftClientPool.this.logger.info("failover to next service host={}, port={}", (Object)serviceInfo.getHost(), (Object)serviceInfo.getPort());
                                transport.open();
                            }
                            catch (TTransportException e2) {
                                ThriftClientPool.this.logger.warn("failover fail, services left: {}", (Object)serviceList.size());
                                continue;
                            }
                            break;
                        }
                    }
                    throw new ConnectionFailException("host=" + serviceInfo.getHost() + ", ip=" + serviceInfo.getPort(), e);
                }
                ThriftClient<TServiceClient> client = new ThriftClient<TServiceClient>((TServiceClient)ThriftClientPool.this.clientFactory.apply(transport), (ObjectPool<ThriftClient<TServiceClient>>)ThriftClientPool.this.pool, serviceInfo);
                ThriftClientPool.this.logger.debug("create new object for pool {}", client);
                return client;
            }

            public PooledObject<ThriftClient<T>> wrap(ThriftClient<T> obj) {
                return new DefaultPooledObject(obj);
            }

            public boolean validateObject(PooledObject<ThriftClient<T>> p) {
                ThriftClient client = (ThriftClient)p.getObject();
                if (ThriftClientPool.this.serviceReset && !ThriftClientPool.this.services.contains(client.getServiceInfo())) {
                    ThriftClientPool.this.logger.warn("not return object because it's from previous config {}", (Object)client);
                    client.closeClient();
                    return false;
                }
                return super.validateObject(p);
            }

            public void destroyObject(PooledObject<ThriftClient<T>> p) throws Exception {
                ((ThriftClient)p.getObject()).closeClient();
                super.destroyObject(p);
            }
        }, (GenericObjectPoolConfig)this.poolConfig);
    }

    public List<ServiceInfo> getServices() {
        return this.services;
    }

    public void setServices(List<ServiceInfo> services) {
        if (services == null || services.size() == 0) {
            throw new IllegalArgumentException("services is empty!");
        }
        this.services = services;
        this.serviceReset = true;
    }

    private TTransport getTransport(ServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            throw new NoBackendServiceException();
        }
        TSocket transport = this.poolConfig.getTimeout() > 0 ? new TSocket(serviceInfo.getHost(), serviceInfo.getPort(), this.poolConfig.getTimeout()) : new TSocket(serviceInfo.getHost(), serviceInfo.getPort());
        return transport;
    }

    private ServiceInfo getRandomService(List<ServiceInfo> serviceList) {
        if (serviceList == null || serviceList.size() == 0) {
            return null;
        }
        return serviceList.get(RandomUtils.nextInt((int)0, (int)serviceList.size()));
    }

    private List<ServiceInfo> removeFailService(List<ServiceInfo> list, ServiceInfo serviceInfo) {
        this.logger.info("remove service from current service list: host={}, port={}", (Object)serviceInfo.getHost(), (Object)serviceInfo.getPort());
        return list.stream().filter(si -> !serviceInfo.equals(si)).collect(Collectors.toList());
    }

    public ThriftClient<T> getClient() throws ThriftException {
        try {
            return (ThriftClient)this.pool.borrowObject();
        }
        catch (Exception e) {
            if (e instanceof ThriftException) {
                throw (ThriftException)e;
            }
            throw new ThriftException("Get client from pool failed.", e);
        }
    }

    public <X> X iface() {
        ThriftClient client;
        try {
            client = (ThriftClient)this.pool.borrowObject();
        }
        catch (Exception e) {
            if (e instanceof ThriftException) {
                throw (ThriftException)e;
            }
            throw new ThriftException("Get client from pool failed.", e);
        }
        AtomicBoolean returnToPool = new AtomicBoolean(false);
        return (X)Proxy.newProxyInstance(this.getClass().getClassLoader(), client.iFace().getClass().getInterfaces(), (proxy, method, args) -> {
            if (returnToPool.get()) {
                throw new IllegalStateException("Object returned via iface can only used once!");
            }
            boolean success = false;
            try {
                Object result = method.invoke(client.iFace(), args);
                success = true;
                Object object = result;
                return object;
            }
            finally {
                if (success) {
                    this.pool.returnObject((Object)client);
                } else {
                    client.closeClient();
                    this.pool.invalidateObject((Object)client);
                }
                returnToPool.set(true);
            }
        });
    }

    protected void finalize() throws Throwable {
        if (this.pool != null) {
            this.pool.close();
        }
        super.finalize();
    }
}

